<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfManagementOfActivityPeriod ArrayType
 * @subpackage Arrays
 */
class ArrayOfManagementOfActivityPeriod extends AbstractStructArrayBase
{
    /**
     * The ManagementOfActivityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ManagementOfActivityPeriod[]
     */
    public $ManagementOfActivityPeriod;
    /**
     * Constructor method for ArrayOfManagementOfActivityPeriod
     * @uses ArrayOfManagementOfActivityPeriod::setManagementOfActivityPeriod()
     * @param \StructType\ManagementOfActivityPeriod[] $managementOfActivityPeriod
     */
    public function __construct(array $managementOfActivityPeriod = array())
    {
        $this
            ->setManagementOfActivityPeriod($managementOfActivityPeriod);
    }
    /**
     * Get ManagementOfActivityPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ManagementOfActivityPeriod[]|null
     */
    public function getManagementOfActivityPeriod()
    {
        return isset($this->ManagementOfActivityPeriod) ? $this->ManagementOfActivityPeriod : null;
    }
    /**
     * This method is responsible for validating the values passed to the setManagementOfActivityPeriod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setManagementOfActivityPeriod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateManagementOfActivityPeriodForArrayConstraintsFromSetManagementOfActivityPeriod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfManagementOfActivityPeriodManagementOfActivityPeriodItem) {
            // validation for constraint: itemType
            if (!$arrayOfManagementOfActivityPeriodManagementOfActivityPeriodItem instanceof \StructType\ManagementOfActivityPeriod) {
                $invalidValues[] = is_object($arrayOfManagementOfActivityPeriodManagementOfActivityPeriodItem) ? get_class($arrayOfManagementOfActivityPeriodManagementOfActivityPeriodItem) : sprintf('%s(%s)', gettype($arrayOfManagementOfActivityPeriodManagementOfActivityPeriodItem), var_export($arrayOfManagementOfActivityPeriodManagementOfActivityPeriodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ManagementOfActivityPeriod property can only contain items of type \StructType\ManagementOfActivityPeriod, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ManagementOfActivityPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ManagementOfActivityPeriod[] $managementOfActivityPeriod
     * @return \ArrayType\ArrayOfManagementOfActivityPeriod
     */
    public function setManagementOfActivityPeriod(array $managementOfActivityPeriod = array())
    {
        // validation for constraint: array
        if ('' !== ($managementOfActivityPeriodArrayErrorMessage = self::validateManagementOfActivityPeriodForArrayConstraintsFromSetManagementOfActivityPeriod($managementOfActivityPeriod))) {
            throw new \InvalidArgumentException($managementOfActivityPeriodArrayErrorMessage, __LINE__);
        }
        if (is_null($managementOfActivityPeriod) || (is_array($managementOfActivityPeriod) && empty($managementOfActivityPeriod))) {
            unset($this->ManagementOfActivityPeriod);
        } else {
            $this->ManagementOfActivityPeriod = $managementOfActivityPeriod;
        }
        return $this;
    }
    /**
     * Add item to ManagementOfActivityPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\ManagementOfActivityPeriod $item
     * @return \ArrayType\ArrayOfManagementOfActivityPeriod
     */
    public function addToManagementOfActivityPeriod(\StructType\ManagementOfActivityPeriod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ManagementOfActivityPeriod) {
            throw new \InvalidArgumentException(sprintf('The ManagementOfActivityPeriod property can only contain items of type \StructType\ManagementOfActivityPeriod, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ManagementOfActivityPeriod[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ManagementOfActivityPeriod|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ManagementOfActivityPeriod|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ManagementOfActivityPeriod|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ManagementOfActivityPeriod|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ManagementOfActivityPeriod|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ManagementOfActivityPeriod
     */
    public function getAttributeName()
    {
        return 'ManagementOfActivityPeriod';
    }
}
