<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobItemResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobItemResult extends AbstractStructArrayBase
{
    /**
     * The JobItemResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JobItemResult[]
     */
    public $JobItemResult;
    /**
     * Constructor method for ArrayOfJobItemResult
     * @uses ArrayOfJobItemResult::setJobItemResult()
     * @param \StructType\JobItemResult[] $jobItemResult
     */
    public function __construct(array $jobItemResult = array())
    {
        $this
            ->setJobItemResult($jobItemResult);
    }
    /**
     * Get JobItemResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JobItemResult[]|null
     */
    public function getJobItemResult()
    {
        return isset($this->JobItemResult) ? $this->JobItemResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setJobItemResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJobItemResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJobItemResultForArrayConstraintsFromSetJobItemResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJobItemResultJobItemResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfJobItemResultJobItemResultItem instanceof \StructType\JobItemResult) {
                $invalidValues[] = is_object($arrayOfJobItemResultJobItemResultItem) ? get_class($arrayOfJobItemResultJobItemResultItem) : sprintf('%s(%s)', gettype($arrayOfJobItemResultJobItemResultItem), var_export($arrayOfJobItemResultJobItemResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JobItemResult property can only contain items of type \StructType\JobItemResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JobItemResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JobItemResult[] $jobItemResult
     * @return \ArrayType\ArrayOfJobItemResult
     */
    public function setJobItemResult(array $jobItemResult = array())
    {
        // validation for constraint: array
        if ('' !== ($jobItemResultArrayErrorMessage = self::validateJobItemResultForArrayConstraintsFromSetJobItemResult($jobItemResult))) {
            throw new \InvalidArgumentException($jobItemResultArrayErrorMessage, __LINE__);
        }
        if (is_null($jobItemResult) || (is_array($jobItemResult) && empty($jobItemResult))) {
            unset($this->JobItemResult);
        } else {
            $this->JobItemResult = $jobItemResult;
        }
        return $this;
    }
    /**
     * Add item to JobItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\JobItemResult $item
     * @return \ArrayType\ArrayOfJobItemResult
     */
    public function addToJobItemResult(\StructType\JobItemResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobItemResult) {
            throw new \InvalidArgumentException(sprintf('The JobItemResult property can only contain items of type \StructType\JobItemResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JobItemResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JobItemResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JobItemResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JobItemResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JobItemResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JobItemResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobItemResult
     */
    public function getAttributeName()
    {
        return 'JobItemResult';
    }
}
