<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobIdentifier ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobIdentifier extends AbstractStructArrayBase
{
    /**
     * The JobIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JobIdentifier[]
     */
    public $JobIdentifier;
    /**
     * Constructor method for ArrayOfJobIdentifier
     * @uses ArrayOfJobIdentifier::setJobIdentifier()
     * @param \StructType\JobIdentifier[] $jobIdentifier
     */
    public function __construct(array $jobIdentifier = array())
    {
        $this
            ->setJobIdentifier($jobIdentifier);
    }
    /**
     * Get JobIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JobIdentifier[]|null
     */
    public function getJobIdentifier()
    {
        return isset($this->JobIdentifier) ? $this->JobIdentifier : null;
    }
    /**
     * This method is responsible for validating the values passed to the setJobIdentifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJobIdentifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJobIdentifierForArrayConstraintsFromSetJobIdentifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJobIdentifierJobIdentifierItem) {
            // validation for constraint: itemType
            if (!$arrayOfJobIdentifierJobIdentifierItem instanceof \StructType\JobIdentifier) {
                $invalidValues[] = is_object($arrayOfJobIdentifierJobIdentifierItem) ? get_class($arrayOfJobIdentifierJobIdentifierItem) : sprintf('%s(%s)', gettype($arrayOfJobIdentifierJobIdentifierItem), var_export($arrayOfJobIdentifierJobIdentifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JobIdentifier property can only contain items of type \StructType\JobIdentifier, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JobIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JobIdentifier[] $jobIdentifier
     * @return \ArrayType\ArrayOfJobIdentifier
     */
    public function setJobIdentifier(array $jobIdentifier = array())
    {
        // validation for constraint: array
        if ('' !== ($jobIdentifierArrayErrorMessage = self::validateJobIdentifierForArrayConstraintsFromSetJobIdentifier($jobIdentifier))) {
            throw new \InvalidArgumentException($jobIdentifierArrayErrorMessage, __LINE__);
        }
        if (is_null($jobIdentifier) || (is_array($jobIdentifier) && empty($jobIdentifier))) {
            unset($this->JobIdentifier);
        } else {
            $this->JobIdentifier = $jobIdentifier;
        }
        return $this;
    }
    /**
     * Add item to JobIdentifier value
     * @throws \InvalidArgumentException
     * @param \StructType\JobIdentifier $item
     * @return \ArrayType\ArrayOfJobIdentifier
     */
    public function addToJobIdentifier(\StructType\JobIdentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobIdentifier) {
            throw new \InvalidArgumentException(sprintf('The JobIdentifier property can only contain items of type \StructType\JobIdentifier, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JobIdentifier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JobIdentifier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JobIdentifier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JobIdentifier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JobIdentifier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JobIdentifier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobIdentifier
     */
    public function getAttributeName()
    {
        return 'JobIdentifier';
    }
}
