<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInfoFieldItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfInfoFieldItem extends AbstractStructArrayBase
{
    /**
     * The InfoFieldItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InfoFieldItem[]
     */
    public $InfoFieldItem;
    /**
     * Constructor method for ArrayOfInfoFieldItem
     * @uses ArrayOfInfoFieldItem::setInfoFieldItem()
     * @param \StructType\InfoFieldItem[] $infoFieldItem
     */
    public function __construct(array $infoFieldItem = array())
    {
        $this
            ->setInfoFieldItem($infoFieldItem);
    }
    /**
     * Get InfoFieldItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InfoFieldItem[]|null
     */
    public function getInfoFieldItem()
    {
        return isset($this->InfoFieldItem) ? $this->InfoFieldItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInfoFieldItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoFieldItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoFieldItemForArrayConstraintsFromSetInfoFieldItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInfoFieldItemInfoFieldItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfInfoFieldItemInfoFieldItemItem instanceof \StructType\InfoFieldItem) {
                $invalidValues[] = is_object($arrayOfInfoFieldItemInfoFieldItemItem) ? get_class($arrayOfInfoFieldItemInfoFieldItemItem) : sprintf('%s(%s)', gettype($arrayOfInfoFieldItemInfoFieldItemItem), var_export($arrayOfInfoFieldItemInfoFieldItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InfoFieldItem property can only contain items of type \StructType\InfoFieldItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InfoFieldItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InfoFieldItem[] $infoFieldItem
     * @return \ArrayType\ArrayOfInfoFieldItem
     */
    public function setInfoFieldItem(array $infoFieldItem = array())
    {
        // validation for constraint: array
        if ('' !== ($infoFieldItemArrayErrorMessage = self::validateInfoFieldItemForArrayConstraintsFromSetInfoFieldItem($infoFieldItem))) {
            throw new \InvalidArgumentException($infoFieldItemArrayErrorMessage, __LINE__);
        }
        if (is_null($infoFieldItem) || (is_array($infoFieldItem) && empty($infoFieldItem))) {
            unset($this->InfoFieldItem);
        } else {
            $this->InfoFieldItem = $infoFieldItem;
        }
        return $this;
    }
    /**
     * Add item to InfoFieldItem value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoFieldItem $item
     * @return \ArrayType\ArrayOfInfoFieldItem
     */
    public function addToInfoFieldItem(\StructType\InfoFieldItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InfoFieldItem) {
            throw new \InvalidArgumentException(sprintf('The InfoFieldItem property can only contain items of type \StructType\InfoFieldItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InfoFieldItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InfoFieldItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InfoFieldItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InfoFieldItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InfoFieldItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InfoFieldItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InfoFieldItem
     */
    public function getAttributeName()
    {
        return 'InfoFieldItem';
    }
}
