<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocumentResult_V4 ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocumentResult_V4 extends AbstractStructArrayBase
{
    /**
     * The DocumentResult_V4
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentResult_V4[]
     */
    public $DocumentResult_V4;
    /**
     * Constructor method for ArrayOfDocumentResult_V4
     * @uses ArrayOfDocumentResult_V4::setDocumentResult_V4()
     * @param \StructType\DocumentResult_V4[] $documentResult_V4
     */
    public function __construct(array $documentResult_V4 = array())
    {
        $this
            ->setDocumentResult_V4($documentResult_V4);
    }
    /**
     * Get DocumentResult_V4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentResult_V4[]|null
     */
    public function getDocumentResult_V4()
    {
        return isset($this->DocumentResult_V4) ? $this->DocumentResult_V4 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentResult_V4 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentResult_V4 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentResult_V4ForArrayConstraintsFromSetDocumentResult_V4(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDocumentResult_V4DocumentResult_V4Item) {
            // validation for constraint: itemType
            if (!$arrayOfDocumentResult_V4DocumentResult_V4Item instanceof \StructType\DocumentResult_V4) {
                $invalidValues[] = is_object($arrayOfDocumentResult_V4DocumentResult_V4Item) ? get_class($arrayOfDocumentResult_V4DocumentResult_V4Item) : sprintf('%s(%s)', gettype($arrayOfDocumentResult_V4DocumentResult_V4Item), var_export($arrayOfDocumentResult_V4DocumentResult_V4Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentResult_V4 property can only contain items of type \StructType\DocumentResult_V4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentResult_V4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentResult_V4[] $documentResult_V4
     * @return \ArrayType\ArrayOfDocumentResult_V4
     */
    public function setDocumentResult_V4(array $documentResult_V4 = array())
    {
        // validation for constraint: array
        if ('' !== ($documentResult_V4ArrayErrorMessage = self::validateDocumentResult_V4ForArrayConstraintsFromSetDocumentResult_V4($documentResult_V4))) {
            throw new \InvalidArgumentException($documentResult_V4ArrayErrorMessage, __LINE__);
        }
        if (is_null($documentResult_V4) || (is_array($documentResult_V4) && empty($documentResult_V4))) {
            unset($this->DocumentResult_V4);
        } else {
            $this->DocumentResult_V4 = $documentResult_V4;
        }
        return $this;
    }
    /**
     * Add item to DocumentResult_V4 value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentResult_V4 $item
     * @return \ArrayType\ArrayOfDocumentResult_V4
     */
    public function addToDocumentResult_V4(\StructType\DocumentResult_V4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentResult_V4) {
            throw new \InvalidArgumentException(sprintf('The DocumentResult_V4 property can only contain items of type \StructType\DocumentResult_V4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentResult_V4[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DocumentResult_V4|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DocumentResult_V4|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DocumentResult_V4|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DocumentResult_V4|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DocumentResult_V4|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DocumentResult_V4
     */
    public function getAttributeName()
    {
        return 'DocumentResult_V4';
    }
}
