<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAlarmMessageResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfAlarmMessageResult extends AbstractStructArrayBase
{
    /**
     * The AlarmMessageResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AlarmMessageResult[]
     */
    public $AlarmMessageResult;
    /**
     * Constructor method for ArrayOfAlarmMessageResult
     * @uses ArrayOfAlarmMessageResult::setAlarmMessageResult()
     * @param \StructType\AlarmMessageResult[] $alarmMessageResult
     */
    public function __construct(array $alarmMessageResult = array())
    {
        $this
            ->setAlarmMessageResult($alarmMessageResult);
    }
    /**
     * Get AlarmMessageResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AlarmMessageResult[]|null
     */
    public function getAlarmMessageResult()
    {
        return isset($this->AlarmMessageResult) ? $this->AlarmMessageResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAlarmMessageResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlarmMessageResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlarmMessageResultForArrayConstraintsFromSetAlarmMessageResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAlarmMessageResultAlarmMessageResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfAlarmMessageResultAlarmMessageResultItem instanceof \StructType\AlarmMessageResult) {
                $invalidValues[] = is_object($arrayOfAlarmMessageResultAlarmMessageResultItem) ? get_class($arrayOfAlarmMessageResultAlarmMessageResultItem) : sprintf('%s(%s)', gettype($arrayOfAlarmMessageResultAlarmMessageResultItem), var_export($arrayOfAlarmMessageResultAlarmMessageResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlarmMessageResult property can only contain items of type \StructType\AlarmMessageResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlarmMessageResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AlarmMessageResult[] $alarmMessageResult
     * @return \ArrayType\ArrayOfAlarmMessageResult
     */
    public function setAlarmMessageResult(array $alarmMessageResult = array())
    {
        // validation for constraint: array
        if ('' !== ($alarmMessageResultArrayErrorMessage = self::validateAlarmMessageResultForArrayConstraintsFromSetAlarmMessageResult($alarmMessageResult))) {
            throw new \InvalidArgumentException($alarmMessageResultArrayErrorMessage, __LINE__);
        }
        if (is_null($alarmMessageResult) || (is_array($alarmMessageResult) && empty($alarmMessageResult))) {
            unset($this->AlarmMessageResult);
        } else {
            $this->AlarmMessageResult = $alarmMessageResult;
        }
        return $this;
    }
    /**
     * Add item to AlarmMessageResult value
     * @throws \InvalidArgumentException
     * @param \StructType\AlarmMessageResult $item
     * @return \ArrayType\ArrayOfAlarmMessageResult
     */
    public function addToAlarmMessageResult(\StructType\AlarmMessageResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AlarmMessageResult) {
            throw new \InvalidArgumentException(sprintf('The AlarmMessageResult property can only contain items of type \StructType\AlarmMessageResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlarmMessageResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AlarmMessageResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AlarmMessageResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AlarmMessageResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AlarmMessageResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AlarmMessageResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AlarmMessageResult
     */
    public function getAttributeName()
    {
        return 'AlarmMessageResult';
    }
}
