<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityTrailerReportItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityTrailerReportItem extends AbstractStructArrayBase
{
    /**
     * The ActivityTrailerReportItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityTrailerReportItem[]
     */
    public $ActivityTrailerReportItem;
    /**
     * Constructor method for ArrayOfActivityTrailerReportItem
     * @uses ArrayOfActivityTrailerReportItem::setActivityTrailerReportItem()
     * @param \StructType\ActivityTrailerReportItem[] $activityTrailerReportItem
     */
    public function __construct(array $activityTrailerReportItem = array())
    {
        $this
            ->setActivityTrailerReportItem($activityTrailerReportItem);
    }
    /**
     * Get ActivityTrailerReportItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityTrailerReportItem[]|null
     */
    public function getActivityTrailerReportItem()
    {
        return isset($this->ActivityTrailerReportItem) ? $this->ActivityTrailerReportItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setActivityTrailerReportItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivityTrailerReportItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityTrailerReportItemForArrayConstraintsFromSetActivityTrailerReportItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfActivityTrailerReportItemActivityTrailerReportItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityTrailerReportItemActivityTrailerReportItemItem instanceof \StructType\ActivityTrailerReportItem) {
                $invalidValues[] = is_object($arrayOfActivityTrailerReportItemActivityTrailerReportItemItem) ? get_class($arrayOfActivityTrailerReportItemActivityTrailerReportItemItem) : sprintf('%s(%s)', gettype($arrayOfActivityTrailerReportItemActivityTrailerReportItemItem), var_export($arrayOfActivityTrailerReportItemActivityTrailerReportItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActivityTrailerReportItem property can only contain items of type \StructType\ActivityTrailerReportItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ActivityTrailerReportItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityTrailerReportItem[] $activityTrailerReportItem
     * @return \ArrayType\ArrayOfActivityTrailerReportItem
     */
    public function setActivityTrailerReportItem(array $activityTrailerReportItem = array())
    {
        // validation for constraint: array
        if ('' !== ($activityTrailerReportItemArrayErrorMessage = self::validateActivityTrailerReportItemForArrayConstraintsFromSetActivityTrailerReportItem($activityTrailerReportItem))) {
            throw new \InvalidArgumentException($activityTrailerReportItemArrayErrorMessage, __LINE__);
        }
        if (is_null($activityTrailerReportItem) || (is_array($activityTrailerReportItem) && empty($activityTrailerReportItem))) {
            unset($this->ActivityTrailerReportItem);
        } else {
            $this->ActivityTrailerReportItem = $activityTrailerReportItem;
        }
        return $this;
    }
    /**
     * Add item to ActivityTrailerReportItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityTrailerReportItem $item
     * @return \ArrayType\ArrayOfActivityTrailerReportItem
     */
    public function addToActivityTrailerReportItem(\StructType\ActivityTrailerReportItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityTrailerReportItem) {
            throw new \InvalidArgumentException(sprintf('The ActivityTrailerReportItem property can only contain items of type \StructType\ActivityTrailerReportItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActivityTrailerReportItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityTrailerReportItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityTrailerReportItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityTrailerReportItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityTrailerReportItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityTrailerReportItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityTrailerReportItem
     */
    public function getAttributeName()
    {
        return 'ActivityTrailerReportItem';
    }
}
