<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkingCodeDuration StructType
 * @subpackage Structs
 */
class WorkingCodeDuration extends CodeInfo
{
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Duration;
    /**
     * The DateBegin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateBegin;
    /**
     * The DateEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateEnd;
    /**
     * Constructor method for WorkingCodeDuration
     * @uses WorkingCodeDuration::setDuration()
     * @uses WorkingCodeDuration::setDateBegin()
     * @uses WorkingCodeDuration::setDateEnd()
     * @param int $duration
     * @param string $dateBegin
     * @param string $dateEnd
     */
    public function __construct($duration = null, $dateBegin = null, $dateEnd = null)
    {
        $this
            ->setDuration($duration)
            ->setDateBegin($dateBegin)
            ->setDateEnd($dateEnd);
    }
    /**
     * Get Duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\WorkingCodeDuration
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get DateBegin value
     * @return string
     */
    public function getDateBegin()
    {
        return $this->DateBegin;
    }
    /**
     * Set DateBegin value
     * @param string $dateBegin
     * @return \StructType\WorkingCodeDuration
     */
    public function setDateBegin($dateBegin = null)
    {
        // validation for constraint: string
        if (!is_null($dateBegin) && !is_string($dateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateBegin, true), gettype($dateBegin)), __LINE__);
        }
        $this->DateBegin = $dateBegin;
        return $this;
    }
    /**
     * Get DateEnd value
     * @return string
     */
    public function getDateEnd()
    {
        return $this->DateEnd;
    }
    /**
     * Set DateEnd value
     * @param string $dateEnd
     * @return \StructType\WorkingCodeDuration
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEnd, true), gettype($dateEnd)), __LINE__);
        }
        $this->DateEnd = $dateEnd;
        return $this;
    }
}
