<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViaRouteUpdate StructType
 * @subpackage Structs
 */
class ViaRouteUpdate extends AbstractStructBase
{
    /**
     * The ViaRouteUpdateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ViaRouteUpdateType;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The IsReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsReference;
    /**
     * The Secure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Secure;
    /**
     * The ViaRouteType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ViaRouteType;
    /**
     * The ViaRoutePlanningType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ViaRoutePlanningType;
    /**
     * The ViaRouteBehavior
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ViaRouteBehavior;
    /**
     * The ViaRouteToUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierViaRoute
     */
    public $ViaRouteToUpdate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ViaPoints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfViaPointUpdate
     */
    public $ViaPoints;
    /**
     * Constructor method for ViaRouteUpdate
     * @uses ViaRouteUpdate::setViaRouteUpdateType()
     * @uses ViaRouteUpdate::setActive()
     * @uses ViaRouteUpdate::setIsReference()
     * @uses ViaRouteUpdate::setSecure()
     * @uses ViaRouteUpdate::setViaRouteType()
     * @uses ViaRouteUpdate::setViaRoutePlanningType()
     * @uses ViaRouteUpdate::setViaRouteBehavior()
     * @uses ViaRouteUpdate::setViaRouteToUpdate()
     * @uses ViaRouteUpdate::setName()
     * @uses ViaRouteUpdate::setDescription()
     * @uses ViaRouteUpdate::setViaPoints()
     * @param string $viaRouteUpdateType
     * @param bool $active
     * @param bool $isReference
     * @param bool $secure
     * @param string $viaRouteType
     * @param string $viaRoutePlanningType
     * @param string $viaRouteBehavior
     * @param \StructType\IdentifierViaRoute $viaRouteToUpdate
     * @param string $name
     * @param string $description
     * @param \ArrayType\ArrayOfViaPointUpdate $viaPoints
     */
    public function __construct($viaRouteUpdateType = null, $active = null, $isReference = null, $secure = null, $viaRouteType = null, $viaRoutePlanningType = null, $viaRouteBehavior = null, \StructType\IdentifierViaRoute $viaRouteToUpdate = null, $name = null, $description = null, \ArrayType\ArrayOfViaPointUpdate $viaPoints = null)
    {
        $this
            ->setViaRouteUpdateType($viaRouteUpdateType)
            ->setActive($active)
            ->setIsReference($isReference)
            ->setSecure($secure)
            ->setViaRouteType($viaRouteType)
            ->setViaRoutePlanningType($viaRoutePlanningType)
            ->setViaRouteBehavior($viaRouteBehavior)
            ->setViaRouteToUpdate($viaRouteToUpdate)
            ->setName($name)
            ->setDescription($description)
            ->setViaPoints($viaPoints);
    }
    /**
     * Get ViaRouteUpdateType value
     * @return string
     */
    public function getViaRouteUpdateType()
    {
        return $this->ViaRouteUpdateType;
    }
    /**
     * Set ViaRouteUpdateType value
     * @uses \EnumType\EnumViaRouteUpdateType::valueIsValid()
     * @uses \EnumType\EnumViaRouteUpdateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $viaRouteUpdateType
     * @return \StructType\ViaRouteUpdate
     */
    public function setViaRouteUpdateType($viaRouteUpdateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumViaRouteUpdateType::valueIsValid($viaRouteUpdateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumViaRouteUpdateType', is_array($viaRouteUpdateType) ? implode(', ', $viaRouteUpdateType) : var_export($viaRouteUpdateType, true), implode(', ', \EnumType\EnumViaRouteUpdateType::getValidValues())), __LINE__);
        }
        $this->ViaRouteUpdateType = $viaRouteUpdateType;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\ViaRouteUpdate
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get IsReference value
     * @return bool
     */
    public function getIsReference()
    {
        return $this->IsReference;
    }
    /**
     * Set IsReference value
     * @param bool $isReference
     * @return \StructType\ViaRouteUpdate
     */
    public function setIsReference($isReference = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReference) && !is_bool($isReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReference, true), gettype($isReference)), __LINE__);
        }
        $this->IsReference = $isReference;
        return $this;
    }
    /**
     * Get Secure value
     * @return bool
     */
    public function getSecure()
    {
        return $this->Secure;
    }
    /**
     * Set Secure value
     * @param bool $secure
     * @return \StructType\ViaRouteUpdate
     */
    public function setSecure($secure = null)
    {
        // validation for constraint: boolean
        if (!is_null($secure) && !is_bool($secure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($secure, true), gettype($secure)), __LINE__);
        }
        $this->Secure = $secure;
        return $this;
    }
    /**
     * Get ViaRouteType value
     * @return string
     */
    public function getViaRouteType()
    {
        return $this->ViaRouteType;
    }
    /**
     * Set ViaRouteType value
     * @uses \EnumType\EnumViaRouteType::valueIsValid()
     * @uses \EnumType\EnumViaRouteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $viaRouteType
     * @return \StructType\ViaRouteUpdate
     */
    public function setViaRouteType($viaRouteType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumViaRouteType::valueIsValid($viaRouteType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumViaRouteType', is_array($viaRouteType) ? implode(', ', $viaRouteType) : var_export($viaRouteType, true), implode(', ', \EnumType\EnumViaRouteType::getValidValues())), __LINE__);
        }
        $this->ViaRouteType = $viaRouteType;
        return $this;
    }
    /**
     * Get ViaRoutePlanningType value
     * @return string
     */
    public function getViaRoutePlanningType()
    {
        return $this->ViaRoutePlanningType;
    }
    /**
     * Set ViaRoutePlanningType value
     * @uses \EnumType\EnumViaRoutePlanningType::valueIsValid()
     * @uses \EnumType\EnumViaRoutePlanningType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $viaRoutePlanningType
     * @return \StructType\ViaRouteUpdate
     */
    public function setViaRoutePlanningType($viaRoutePlanningType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumViaRoutePlanningType::valueIsValid($viaRoutePlanningType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumViaRoutePlanningType', is_array($viaRoutePlanningType) ? implode(', ', $viaRoutePlanningType) : var_export($viaRoutePlanningType, true), implode(', ', \EnumType\EnumViaRoutePlanningType::getValidValues())), __LINE__);
        }
        $this->ViaRoutePlanningType = $viaRoutePlanningType;
        return $this;
    }
    /**
     * Get ViaRouteBehavior value
     * @return string
     */
    public function getViaRouteBehavior()
    {
        return $this->ViaRouteBehavior;
    }
    /**
     * Set ViaRouteBehavior value
     * @uses \EnumType\EnumViaRouteBehavior::valueIsValid()
     * @uses \EnumType\EnumViaRouteBehavior::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $viaRouteBehavior
     * @return \StructType\ViaRouteUpdate
     */
    public function setViaRouteBehavior($viaRouteBehavior = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumViaRouteBehavior::valueIsValid($viaRouteBehavior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumViaRouteBehavior', is_array($viaRouteBehavior) ? implode(', ', $viaRouteBehavior) : var_export($viaRouteBehavior, true), implode(', ', \EnumType\EnumViaRouteBehavior::getValidValues())), __LINE__);
        }
        $this->ViaRouteBehavior = $viaRouteBehavior;
        return $this;
    }
    /**
     * Get ViaRouteToUpdate value
     * @return \StructType\IdentifierViaRoute|null
     */
    public function getViaRouteToUpdate()
    {
        return $this->ViaRouteToUpdate;
    }
    /**
     * Set ViaRouteToUpdate value
     * @param \StructType\IdentifierViaRoute $viaRouteToUpdate
     * @return \StructType\ViaRouteUpdate
     */
    public function setViaRouteToUpdate(\StructType\IdentifierViaRoute $viaRouteToUpdate = null)
    {
        $this->ViaRouteToUpdate = $viaRouteToUpdate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ViaRouteUpdate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ViaRouteUpdate
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ViaPoints value
     * @return \ArrayType\ArrayOfViaPointUpdate|null
     */
    public function getViaPoints()
    {
        return $this->ViaPoints;
    }
    /**
     * Set ViaPoints value
     * @param \ArrayType\ArrayOfViaPointUpdate $viaPoints
     * @return \StructType\ViaRouteUpdate
     */
    public function setViaPoints(\ArrayType\ArrayOfViaPointUpdate $viaPoints = null)
    {
        $this->ViaPoints = $viaPoints;
        return $this;
    }
}
