<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vehicle_V2 StructType
 * @subpackage Structs
 */
abstract class Vehicle_V2 extends AbstractStructBase
{
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Inactive;
    /**
     * The CanBusConnection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CanBusConnection;
    /**
     * The VehicleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleID;
    /**
     * The VehicleExternalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleExternalCode;
    /**
     * The LicensePlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LicensePlate;
    /**
     * The ShortName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortName;
    /**
     * The Picture
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Picture;
    /**
     * The PictureSerialized
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PictureSerialized;
    /**
     * The EngineInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleEngineInfo_V2
     */
    public $EngineInfo;
    /**
     * The TechnicalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleTechnicalInfo
     */
    public $TechnicalInfo;
    /**
     * The LoadInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleLoadInfo
     */
    public $LoadInfo;
    /**
     * The ComfortInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleComfortInfo
     */
    public $ComfortInfo;
    /**
     * Constructor method for Vehicle_V2
     * @uses Vehicle_V2::setInactive()
     * @uses Vehicle_V2::setCanBusConnection()
     * @uses Vehicle_V2::setVehicleID()
     * @uses Vehicle_V2::setVehicleExternalCode()
     * @uses Vehicle_V2::setLicensePlate()
     * @uses Vehicle_V2::setShortName()
     * @uses Vehicle_V2::setPicture()
     * @uses Vehicle_V2::setPictureSerialized()
     * @uses Vehicle_V2::setEngineInfo()
     * @uses Vehicle_V2::setTechnicalInfo()
     * @uses Vehicle_V2::setLoadInfo()
     * @uses Vehicle_V2::setComfortInfo()
     * @param bool $inactive
     * @param bool $canBusConnection
     * @param string $vehicleID
     * @param string $vehicleExternalCode
     * @param string $licensePlate
     * @param string $shortName
     * @param string $picture
     * @param string $pictureSerialized
     * @param \StructType\VehicleEngineInfo_V2 $engineInfo
     * @param \StructType\VehicleTechnicalInfo $technicalInfo
     * @param \StructType\VehicleLoadInfo $loadInfo
     * @param \StructType\VehicleComfortInfo $comfortInfo
     */
    public function __construct($inactive = null, $canBusConnection = null, $vehicleID = null, $vehicleExternalCode = null, $licensePlate = null, $shortName = null, $picture = null, $pictureSerialized = null, \StructType\VehicleEngineInfo_V2 $engineInfo = null, \StructType\VehicleTechnicalInfo $technicalInfo = null, \StructType\VehicleLoadInfo $loadInfo = null, \StructType\VehicleComfortInfo $comfortInfo = null)
    {
        $this
            ->setInactive($inactive)
            ->setCanBusConnection($canBusConnection)
            ->setVehicleID($vehicleID)
            ->setVehicleExternalCode($vehicleExternalCode)
            ->setLicensePlate($licensePlate)
            ->setShortName($shortName)
            ->setPicture($picture)
            ->setPictureSerialized($pictureSerialized)
            ->setEngineInfo($engineInfo)
            ->setTechnicalInfo($technicalInfo)
            ->setLoadInfo($loadInfo)
            ->setComfortInfo($comfortInfo);
    }
    /**
     * Get Inactive value
     * @return bool
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Vehicle_V2
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get CanBusConnection value
     * @return bool
     */
    public function getCanBusConnection()
    {
        return $this->CanBusConnection;
    }
    /**
     * Set CanBusConnection value
     * @param bool $canBusConnection
     * @return \StructType\Vehicle_V2
     */
    public function setCanBusConnection($canBusConnection = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBusConnection) && !is_bool($canBusConnection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canBusConnection, true), gettype($canBusConnection)), __LINE__);
        }
        $this->CanBusConnection = $canBusConnection;
        return $this;
    }
    /**
     * Get VehicleID value
     * @return string|null
     */
    public function getVehicleID()
    {
        return $this->VehicleID;
    }
    /**
     * Set VehicleID value
     * @param string $vehicleID
     * @return \StructType\Vehicle_V2
     */
    public function setVehicleID($vehicleID = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleID) && !is_string($vehicleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleID, true), gettype($vehicleID)), __LINE__);
        }
        $this->VehicleID = $vehicleID;
        return $this;
    }
    /**
     * Get VehicleExternalCode value
     * @return string|null
     */
    public function getVehicleExternalCode()
    {
        return $this->VehicleExternalCode;
    }
    /**
     * Set VehicleExternalCode value
     * @param string $vehicleExternalCode
     * @return \StructType\Vehicle_V2
     */
    public function setVehicleExternalCode($vehicleExternalCode = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleExternalCode) && !is_string($vehicleExternalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleExternalCode, true), gettype($vehicleExternalCode)), __LINE__);
        }
        $this->VehicleExternalCode = $vehicleExternalCode;
        return $this;
    }
    /**
     * Get LicensePlate value
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->LicensePlate;
    }
    /**
     * Set LicensePlate value
     * @param string $licensePlate
     * @return \StructType\Vehicle_V2
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlate, true), gettype($licensePlate)), __LINE__);
        }
        $this->LicensePlate = $licensePlate;
        return $this;
    }
    /**
     * Get ShortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->ShortName;
    }
    /**
     * Set ShortName value
     * @param string $shortName
     * @return \StructType\Vehicle_V2
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortName, true), gettype($shortName)), __LINE__);
        }
        $this->ShortName = $shortName;
        return $this;
    }
    /**
     * Get Picture value
     * @return string|null
     */
    public function getPicture()
    {
        return $this->Picture;
    }
    /**
     * Set Picture value
     * @param string $picture
     * @return \StructType\Vehicle_V2
     */
    public function setPicture($picture = null)
    {
        // validation for constraint: string
        if (!is_null($picture) && !is_string($picture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($picture, true), gettype($picture)), __LINE__);
        }
        $this->Picture = $picture;
        return $this;
    }
    /**
     * Get PictureSerialized value
     * @return string|null
     */
    public function getPictureSerialized()
    {
        return $this->PictureSerialized;
    }
    /**
     * Set PictureSerialized value
     * @param string $pictureSerialized
     * @return \StructType\Vehicle_V2
     */
    public function setPictureSerialized($pictureSerialized = null)
    {
        // validation for constraint: string
        if (!is_null($pictureSerialized) && !is_string($pictureSerialized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pictureSerialized, true), gettype($pictureSerialized)), __LINE__);
        }
        $this->PictureSerialized = $pictureSerialized;
        return $this;
    }
    /**
     * Get EngineInfo value
     * @return \StructType\VehicleEngineInfo_V2|null
     */
    public function getEngineInfo()
    {
        return $this->EngineInfo;
    }
    /**
     * Set EngineInfo value
     * @param \StructType\VehicleEngineInfo_V2 $engineInfo
     * @return \StructType\Vehicle_V2
     */
    public function setEngineInfo(\StructType\VehicleEngineInfo_V2 $engineInfo = null)
    {
        $this->EngineInfo = $engineInfo;
        return $this;
    }
    /**
     * Get TechnicalInfo value
     * @return \StructType\VehicleTechnicalInfo|null
     */
    public function getTechnicalInfo()
    {
        return $this->TechnicalInfo;
    }
    /**
     * Set TechnicalInfo value
     * @param \StructType\VehicleTechnicalInfo $technicalInfo
     * @return \StructType\Vehicle_V2
     */
    public function setTechnicalInfo(\StructType\VehicleTechnicalInfo $technicalInfo = null)
    {
        $this->TechnicalInfo = $technicalInfo;
        return $this;
    }
    /**
     * Get LoadInfo value
     * @return \StructType\VehicleLoadInfo|null
     */
    public function getLoadInfo()
    {
        return $this->LoadInfo;
    }
    /**
     * Set LoadInfo value
     * @param \StructType\VehicleLoadInfo $loadInfo
     * @return \StructType\Vehicle_V2
     */
    public function setLoadInfo(\StructType\VehicleLoadInfo $loadInfo = null)
    {
        $this->LoadInfo = $loadInfo;
        return $this;
    }
    /**
     * Get ComfortInfo value
     * @return \StructType\VehicleComfortInfo|null
     */
    public function getComfortInfo()
    {
        return $this->ComfortInfo;
    }
    /**
     * Set ComfortInfo value
     * @param \StructType\VehicleComfortInfo $comfortInfo
     * @return \StructType\Vehicle_V2
     */
    public function setComfortInfo(\StructType\VehicleComfortInfo $comfortInfo = null)
    {
        $this->ComfortInfo = $comfortInfo;
        return $this;
    }
}
