<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleResult_With_NextStop_Info StructType
 * @subpackage Structs
 */
class VehicleResult_With_NextStop_Info extends Vehicle
{
    /**
     * The VehicleTransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VehicleTransicsID;
    /**
     * The Modified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modified;
    /**
     * The CurrentKms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurrentKms;
    /**
     * The FuelLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevel;
    /**
     * The FuelLevelIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevelIndex;
    /**
     * The RefrigeratorIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RefrigeratorIndex;
    /**
     * The ActivityCompleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ActivityCompleted;
    /**
     * The LastTrailerCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastTrailerCode;
    /**
     * The Site
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierResult
     */
    public $Site;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $CoDriver;
    /**
     * The ObcInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleObcInfo
     */
    public $ObcInfo;
    /**
     * The ETAInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleETAInfo
     */
    public $ETAInfo;
    /**
     * The TemperatureInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleTemperatureInfo
     */
    public $TemperatureInfo;
    /**
     * The InfoFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleInfoFields
     */
    public $InfoFields;
    /**
     * The UpdateDates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleUpdateDates
     */
    public $UpdateDates;
    /**
     * The VehicleCostInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VehicleCostInfo
     */
    public $VehicleCostInfo;
    /**
     * The NextStopInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NextStopResult
     */
    public $NextStopInfo;
    /**
     * Constructor method for VehicleResult_With_NextStop_Info
     * @uses VehicleResult_With_NextStop_Info::setVehicleTransicsID()
     * @uses VehicleResult_With_NextStop_Info::setModified()
     * @uses VehicleResult_With_NextStop_Info::setCurrentKms()
     * @uses VehicleResult_With_NextStop_Info::setFuelLevel()
     * @uses VehicleResult_With_NextStop_Info::setFuelLevelIndex()
     * @uses VehicleResult_With_NextStop_Info::setRefrigeratorIndex()
     * @uses VehicleResult_With_NextStop_Info::setActivityCompleted()
     * @uses VehicleResult_With_NextStop_Info::setLastTrailerCode()
     * @uses VehicleResult_With_NextStop_Info::setSite()
     * @uses VehicleResult_With_NextStop_Info::setPosition()
     * @uses VehicleResult_With_NextStop_Info::setActivity()
     * @uses VehicleResult_With_NextStop_Info::setDriver()
     * @uses VehicleResult_With_NextStop_Info::setCoDriver()
     * @uses VehicleResult_With_NextStop_Info::setObcInfo()
     * @uses VehicleResult_With_NextStop_Info::setETAInfo()
     * @uses VehicleResult_With_NextStop_Info::setTemperatureInfo()
     * @uses VehicleResult_With_NextStop_Info::setInfoFields()
     * @uses VehicleResult_With_NextStop_Info::setUpdateDates()
     * @uses VehicleResult_With_NextStop_Info::setVehicleCostInfo()
     * @uses VehicleResult_With_NextStop_Info::setNextStopInfo()
     * @param int $vehicleTransicsID
     * @param string $modified
     * @param int $currentKms
     * @param int $fuelLevel
     * @param int $fuelLevelIndex
     * @param int $refrigeratorIndex
     * @param bool $activityCompleted
     * @param string $lastTrailerCode
     * @param \StructType\IdentifierResult $site
     * @param \StructType\PositionResult $position
     * @param \StructType\Activity $activity
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierPerson $coDriver
     * @param \StructType\VehicleObcInfo $obcInfo
     * @param \StructType\VehicleETAInfo $eTAInfo
     * @param \StructType\VehicleTemperatureInfo $temperatureInfo
     * @param \StructType\VehicleInfoFields $infoFields
     * @param \StructType\VehicleUpdateDates $updateDates
     * @param \StructType\VehicleCostInfo $vehicleCostInfo
     * @param \StructType\NextStopResult $nextStopInfo
     */
    public function __construct($vehicleTransicsID = null, $modified = null, $currentKms = null, $fuelLevel = null, $fuelLevelIndex = null, $refrigeratorIndex = null, $activityCompleted = null, $lastTrailerCode = null, \StructType\IdentifierResult $site = null, \StructType\PositionResult $position = null, \StructType\Activity $activity = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierPerson $coDriver = null, \StructType\VehicleObcInfo $obcInfo = null, \StructType\VehicleETAInfo $eTAInfo = null, \StructType\VehicleTemperatureInfo $temperatureInfo = null, \StructType\VehicleInfoFields $infoFields = null, \StructType\VehicleUpdateDates $updateDates = null, \StructType\VehicleCostInfo $vehicleCostInfo = null, \StructType\NextStopResult $nextStopInfo = null)
    {
        $this
            ->setVehicleTransicsID($vehicleTransicsID)
            ->setModified($modified)
            ->setCurrentKms($currentKms)
            ->setFuelLevel($fuelLevel)
            ->setFuelLevelIndex($fuelLevelIndex)
            ->setRefrigeratorIndex($refrigeratorIndex)
            ->setActivityCompleted($activityCompleted)
            ->setLastTrailerCode($lastTrailerCode)
            ->setSite($site)
            ->setPosition($position)
            ->setActivity($activity)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setObcInfo($obcInfo)
            ->setETAInfo($eTAInfo)
            ->setTemperatureInfo($temperatureInfo)
            ->setInfoFields($infoFields)
            ->setUpdateDates($updateDates)
            ->setVehicleCostInfo($vehicleCostInfo)
            ->setNextStopInfo($nextStopInfo);
    }
    /**
     * Get VehicleTransicsID value
     * @return int
     */
    public function getVehicleTransicsID()
    {
        return $this->VehicleTransicsID;
    }
    /**
     * Set VehicleTransicsID value
     * @param int $vehicleTransicsID
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setVehicleTransicsID($vehicleTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleTransicsID) && !(is_int($vehicleTransicsID) || ctype_digit($vehicleTransicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleTransicsID, true), gettype($vehicleTransicsID)), __LINE__);
        }
        $this->VehicleTransicsID = $vehicleTransicsID;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modified, true), gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get CurrentKms value
     * @return int
     */
    public function getCurrentKms()
    {
        return $this->CurrentKms;
    }
    /**
     * Set CurrentKms value
     * @param int $currentKms
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setCurrentKms($currentKms = null)
    {
        // validation for constraint: int
        if (!is_null($currentKms) && !(is_int($currentKms) || ctype_digit($currentKms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentKms, true), gettype($currentKms)), __LINE__);
        }
        $this->CurrentKms = $currentKms;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !(is_int($fuelLevel) || ctype_digit($fuelLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelLevel, true), gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get FuelLevelIndex value
     * @return int
     */
    public function getFuelLevelIndex()
    {
        return $this->FuelLevelIndex;
    }
    /**
     * Set FuelLevelIndex value
     * @param int $fuelLevelIndex
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setFuelLevelIndex($fuelLevelIndex = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevelIndex) && !(is_int($fuelLevelIndex) || ctype_digit($fuelLevelIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelLevelIndex, true), gettype($fuelLevelIndex)), __LINE__);
        }
        $this->FuelLevelIndex = $fuelLevelIndex;
        return $this;
    }
    /**
     * Get RefrigeratorIndex value
     * @return int
     */
    public function getRefrigeratorIndex()
    {
        return $this->RefrigeratorIndex;
    }
    /**
     * Set RefrigeratorIndex value
     * @param int $refrigeratorIndex
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setRefrigeratorIndex($refrigeratorIndex = null)
    {
        // validation for constraint: int
        if (!is_null($refrigeratorIndex) && !(is_int($refrigeratorIndex) || ctype_digit($refrigeratorIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refrigeratorIndex, true), gettype($refrigeratorIndex)), __LINE__);
        }
        $this->RefrigeratorIndex = $refrigeratorIndex;
        return $this;
    }
    /**
     * Get ActivityCompleted value
     * @return bool
     */
    public function getActivityCompleted()
    {
        return $this->ActivityCompleted;
    }
    /**
     * Set ActivityCompleted value
     * @param bool $activityCompleted
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setActivityCompleted($activityCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($activityCompleted) && !is_bool($activityCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activityCompleted, true), gettype($activityCompleted)), __LINE__);
        }
        $this->ActivityCompleted = $activityCompleted;
        return $this;
    }
    /**
     * Get LastTrailerCode value
     * @return string|null
     */
    public function getLastTrailerCode()
    {
        return $this->LastTrailerCode;
    }
    /**
     * Set LastTrailerCode value
     * @param string $lastTrailerCode
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setLastTrailerCode($lastTrailerCode = null)
    {
        // validation for constraint: string
        if (!is_null($lastTrailerCode) && !is_string($lastTrailerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTrailerCode, true), gettype($lastTrailerCode)), __LINE__);
        }
        $this->LastTrailerCode = $lastTrailerCode;
        return $this;
    }
    /**
     * Get Site value
     * @return \StructType\IdentifierResult|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\IdentifierResult $site
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setSite(\StructType\IdentifierResult $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson $coDriver
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setCoDriver(\StructType\IdentifierPerson $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get ObcInfo value
     * @return \StructType\VehicleObcInfo|null
     */
    public function getObcInfo()
    {
        return $this->ObcInfo;
    }
    /**
     * Set ObcInfo value
     * @param \StructType\VehicleObcInfo $obcInfo
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setObcInfo(\StructType\VehicleObcInfo $obcInfo = null)
    {
        $this->ObcInfo = $obcInfo;
        return $this;
    }
    /**
     * Get ETAInfo value
     * @return \StructType\VehicleETAInfo|null
     */
    public function getETAInfo()
    {
        return $this->ETAInfo;
    }
    /**
     * Set ETAInfo value
     * @param \StructType\VehicleETAInfo $eTAInfo
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setETAInfo(\StructType\VehicleETAInfo $eTAInfo = null)
    {
        $this->ETAInfo = $eTAInfo;
        return $this;
    }
    /**
     * Get TemperatureInfo value
     * @return \StructType\VehicleTemperatureInfo|null
     */
    public function getTemperatureInfo()
    {
        return $this->TemperatureInfo;
    }
    /**
     * Set TemperatureInfo value
     * @param \StructType\VehicleTemperatureInfo $temperatureInfo
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setTemperatureInfo(\StructType\VehicleTemperatureInfo $temperatureInfo = null)
    {
        $this->TemperatureInfo = $temperatureInfo;
        return $this;
    }
    /**
     * Get InfoFields value
     * @return \StructType\VehicleInfoFields|null
     */
    public function getInfoFields()
    {
        return $this->InfoFields;
    }
    /**
     * Set InfoFields value
     * @param \StructType\VehicleInfoFields $infoFields
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setInfoFields(\StructType\VehicleInfoFields $infoFields = null)
    {
        $this->InfoFields = $infoFields;
        return $this;
    }
    /**
     * Get UpdateDates value
     * @return \StructType\VehicleUpdateDates|null
     */
    public function getUpdateDates()
    {
        return $this->UpdateDates;
    }
    /**
     * Set UpdateDates value
     * @param \StructType\VehicleUpdateDates $updateDates
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setUpdateDates(\StructType\VehicleUpdateDates $updateDates = null)
    {
        $this->UpdateDates = $updateDates;
        return $this;
    }
    /**
     * Get VehicleCostInfo value
     * @return \StructType\VehicleCostInfo|null
     */
    public function getVehicleCostInfo()
    {
        return $this->VehicleCostInfo;
    }
    /**
     * Set VehicleCostInfo value
     * @param \StructType\VehicleCostInfo $vehicleCostInfo
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setVehicleCostInfo(\StructType\VehicleCostInfo $vehicleCostInfo = null)
    {
        $this->VehicleCostInfo = $vehicleCostInfo;
        return $this;
    }
    /**
     * Get NextStopInfo value
     * @return \StructType\NextStopResult|null
     */
    public function getNextStopInfo()
    {
        return $this->NextStopInfo;
    }
    /**
     * Set NextStopInfo value
     * @param \StructType\NextStopResult $nextStopInfo
     * @return \StructType\VehicleResult_With_NextStop_Info
     */
    public function setNextStopInfo(\StructType\NextStopResult $nextStopInfo = null)
    {
        $this->NextStopInfo = $nextStopInfo;
        return $this;
    }
}
