<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleEngineInfo StructType
 * @subpackage Structs
 */
class VehicleEngineInfo extends AbstractStructBase
{
    /**
     * The CilinderCapacity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CilinderCapacity;
    /**
     * The CilinderCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CilinderCount;
    /**
     * The CilinderDiameter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CilinderDiameter;
    /**
     * The KwMotorPower
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $KwMotorPower;
    /**
     * The MaxAllowedRMP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxAllowedRMP;
    /**
     * The Watt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Watt;
    /**
     * The EngineDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EngineDescription;
    /**
     * The EngineSerial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EngineSerial;
    /**
     * Constructor method for VehicleEngineInfo
     * @uses VehicleEngineInfo::setCilinderCapacity()
     * @uses VehicleEngineInfo::setCilinderCount()
     * @uses VehicleEngineInfo::setCilinderDiameter()
     * @uses VehicleEngineInfo::setKwMotorPower()
     * @uses VehicleEngineInfo::setMaxAllowedRMP()
     * @uses VehicleEngineInfo::setWatt()
     * @uses VehicleEngineInfo::setEngineDescription()
     * @uses VehicleEngineInfo::setEngineSerial()
     * @param float $cilinderCapacity
     * @param int $cilinderCount
     * @param int $cilinderDiameter
     * @param float $kwMotorPower
     * @param float $maxAllowedRMP
     * @param int $watt
     * @param string $engineDescription
     * @param string $engineSerial
     */
    public function __construct($cilinderCapacity = null, $cilinderCount = null, $cilinderDiameter = null, $kwMotorPower = null, $maxAllowedRMP = null, $watt = null, $engineDescription = null, $engineSerial = null)
    {
        $this
            ->setCilinderCapacity($cilinderCapacity)
            ->setCilinderCount($cilinderCount)
            ->setCilinderDiameter($cilinderDiameter)
            ->setKwMotorPower($kwMotorPower)
            ->setMaxAllowedRMP($maxAllowedRMP)
            ->setWatt($watt)
            ->setEngineDescription($engineDescription)
            ->setEngineSerial($engineSerial);
    }
    /**
     * Get CilinderCapacity value
     * @return float
     */
    public function getCilinderCapacity()
    {
        return $this->CilinderCapacity;
    }
    /**
     * Set CilinderCapacity value
     * @param float $cilinderCapacity
     * @return \StructType\VehicleEngineInfo
     */
    public function setCilinderCapacity($cilinderCapacity = null)
    {
        // validation for constraint: float
        if (!is_null($cilinderCapacity) && !(is_float($cilinderCapacity) || is_numeric($cilinderCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cilinderCapacity, true), gettype($cilinderCapacity)), __LINE__);
        }
        $this->CilinderCapacity = $cilinderCapacity;
        return $this;
    }
    /**
     * Get CilinderCount value
     * @return int
     */
    public function getCilinderCount()
    {
        return $this->CilinderCount;
    }
    /**
     * Set CilinderCount value
     * @param int $cilinderCount
     * @return \StructType\VehicleEngineInfo
     */
    public function setCilinderCount($cilinderCount = null)
    {
        // validation for constraint: int
        if (!is_null($cilinderCount) && !(is_int($cilinderCount) || ctype_digit($cilinderCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cilinderCount, true), gettype($cilinderCount)), __LINE__);
        }
        $this->CilinderCount = $cilinderCount;
        return $this;
    }
    /**
     * Get CilinderDiameter value
     * @return int
     */
    public function getCilinderDiameter()
    {
        return $this->CilinderDiameter;
    }
    /**
     * Set CilinderDiameter value
     * @param int $cilinderDiameter
     * @return \StructType\VehicleEngineInfo
     */
    public function setCilinderDiameter($cilinderDiameter = null)
    {
        // validation for constraint: int
        if (!is_null($cilinderDiameter) && !(is_int($cilinderDiameter) || ctype_digit($cilinderDiameter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cilinderDiameter, true), gettype($cilinderDiameter)), __LINE__);
        }
        $this->CilinderDiameter = $cilinderDiameter;
        return $this;
    }
    /**
     * Get KwMotorPower value
     * @return float
     */
    public function getKwMotorPower()
    {
        return $this->KwMotorPower;
    }
    /**
     * Set KwMotorPower value
     * @param float $kwMotorPower
     * @return \StructType\VehicleEngineInfo
     */
    public function setKwMotorPower($kwMotorPower = null)
    {
        // validation for constraint: float
        if (!is_null($kwMotorPower) && !(is_float($kwMotorPower) || is_numeric($kwMotorPower))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kwMotorPower, true), gettype($kwMotorPower)), __LINE__);
        }
        $this->KwMotorPower = $kwMotorPower;
        return $this;
    }
    /**
     * Get MaxAllowedRMP value
     * @return float
     */
    public function getMaxAllowedRMP()
    {
        return $this->MaxAllowedRMP;
    }
    /**
     * Set MaxAllowedRMP value
     * @param float $maxAllowedRMP
     * @return \StructType\VehicleEngineInfo
     */
    public function setMaxAllowedRMP($maxAllowedRMP = null)
    {
        // validation for constraint: float
        if (!is_null($maxAllowedRMP) && !(is_float($maxAllowedRMP) || is_numeric($maxAllowedRMP))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxAllowedRMP, true), gettype($maxAllowedRMP)), __LINE__);
        }
        $this->MaxAllowedRMP = $maxAllowedRMP;
        return $this;
    }
    /**
     * Get Watt value
     * @return int
     */
    public function getWatt()
    {
        return $this->Watt;
    }
    /**
     * Set Watt value
     * @param int $watt
     * @return \StructType\VehicleEngineInfo
     */
    public function setWatt($watt = null)
    {
        // validation for constraint: int
        if (!is_null($watt) && !(is_int($watt) || ctype_digit($watt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($watt, true), gettype($watt)), __LINE__);
        }
        $this->Watt = $watt;
        return $this;
    }
    /**
     * Get EngineDescription value
     * @return string|null
     */
    public function getEngineDescription()
    {
        return $this->EngineDescription;
    }
    /**
     * Set EngineDescription value
     * @param string $engineDescription
     * @return \StructType\VehicleEngineInfo
     */
    public function setEngineDescription($engineDescription = null)
    {
        // validation for constraint: string
        if (!is_null($engineDescription) && !is_string($engineDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($engineDescription, true), gettype($engineDescription)), __LINE__);
        }
        $this->EngineDescription = $engineDescription;
        return $this;
    }
    /**
     * Get EngineSerial value
     * @return string|null
     */
    public function getEngineSerial()
    {
        return $this->EngineSerial;
    }
    /**
     * Set EngineSerial value
     * @param string $engineSerial
     * @return \StructType\VehicleEngineInfo
     */
    public function setEngineSerial($engineSerial = null)
    {
        // validation for constraint: string
        if (!is_null($engineSerial) && !is_string($engineSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($engineSerial, true), gettype($engineSerial)), __LINE__);
        }
        $this->EngineSerial = $engineSerial;
        return $this;
    }
}
