<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleEngineDiagnostics StructType
 * @subpackage Structs
 */
class VehicleEngineDiagnostics extends AbstractStructBase
{
    /**
     * The MaxSpeed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaxSpeed;
    /**
     * The MaxRpm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaxRpm;
    /**
     * The FuelUsage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FuelUsage;
    /**
     * Constructor method for VehicleEngineDiagnostics
     * @uses VehicleEngineDiagnostics::setMaxSpeed()
     * @uses VehicleEngineDiagnostics::setMaxRpm()
     * @uses VehicleEngineDiagnostics::setFuelUsage()
     * @param string $maxSpeed
     * @param string $maxRpm
     * @param string $fuelUsage
     */
    public function __construct($maxSpeed = null, $maxRpm = null, $fuelUsage = null)
    {
        $this
            ->setMaxSpeed($maxSpeed)
            ->setMaxRpm($maxRpm)
            ->setFuelUsage($fuelUsage);
    }
    /**
     * Get MaxSpeed value
     * @return string|null
     */
    public function getMaxSpeed()
    {
        return $this->MaxSpeed;
    }
    /**
     * Set MaxSpeed value
     * @param string $maxSpeed
     * @return \StructType\VehicleEngineDiagnostics
     */
    public function setMaxSpeed($maxSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($maxSpeed) && !is_string($maxSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxSpeed, true), gettype($maxSpeed)), __LINE__);
        }
        $this->MaxSpeed = $maxSpeed;
        return $this;
    }
    /**
     * Get MaxRpm value
     * @return string|null
     */
    public function getMaxRpm()
    {
        return $this->MaxRpm;
    }
    /**
     * Set MaxRpm value
     * @param string $maxRpm
     * @return \StructType\VehicleEngineDiagnostics
     */
    public function setMaxRpm($maxRpm = null)
    {
        // validation for constraint: string
        if (!is_null($maxRpm) && !is_string($maxRpm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxRpm, true), gettype($maxRpm)), __LINE__);
        }
        $this->MaxRpm = $maxRpm;
        return $this;
    }
    /**
     * Get FuelUsage value
     * @return string|null
     */
    public function getFuelUsage()
    {
        return $this->FuelUsage;
    }
    /**
     * Set FuelUsage value
     * @param string $fuelUsage
     * @return \StructType\VehicleEngineDiagnostics
     */
    public function setFuelUsage($fuelUsage = null)
    {
        // validation for constraint: string
        if (!is_null($fuelUsage) && !is_string($fuelUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fuelUsage, true), gettype($fuelUsage)), __LINE__);
        }
        $this->FuelUsage = $fuelUsage;
        return $this;
    }
}
