<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSubscription StructType
 * @subpackage Structs
 */
class UpdateSubscription extends AbstractStructBase
{
    /**
     * The SubscriptionStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SubscriptionStatus;
    /**
     * The Feature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Feature;
    /**
     * Constructor method for UpdateSubscription
     * @uses UpdateSubscription::setSubscriptionStatus()
     * @uses UpdateSubscription::setFeature()
     * @param bool $subscriptionStatus
     * @param string $feature
     */
    public function __construct($subscriptionStatus = null, $feature = null)
    {
        $this
            ->setSubscriptionStatus($subscriptionStatus)
            ->setFeature($feature);
    }
    /**
     * Get SubscriptionStatus value
     * @return bool
     */
    public function getSubscriptionStatus()
    {
        return $this->SubscriptionStatus;
    }
    /**
     * Set SubscriptionStatus value
     * @param bool $subscriptionStatus
     * @return \StructType\UpdateSubscription
     */
    public function setSubscriptionStatus($subscriptionStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($subscriptionStatus) && !is_bool($subscriptionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($subscriptionStatus, true), gettype($subscriptionStatus)), __LINE__);
        }
        $this->SubscriptionStatus = $subscriptionStatus;
        return $this;
    }
    /**
     * Get Feature value
     * @return string|null
     */
    public function getFeature()
    {
        return $this->Feature;
    }
    /**
     * Set Feature value
     * @param string $feature
     * @return \StructType\UpdateSubscription
     */
    public function setFeature($feature = null)
    {
        // validation for constraint: string
        if (!is_null($feature) && !is_string($feature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feature, true), gettype($feature)), __LINE__);
        }
        $this->Feature = $feature;
        return $this;
    }
}
