<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripReportTrailerSummary StructType
 * @subpackage Structs
 */
class TripReportTrailerSummary extends AbstractStructBase
{
    /**
     * The AttachementCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AttachementCount;
    /**
     * The TotalDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDuration;
    /**
     * The TotalDistance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDistance;
    /**
     * The TotalConsumption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalConsumption;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Trailer_External
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trailer_External;
    /**
     * Constructor method for TripReportTrailerSummary
     * @uses TripReportTrailerSummary::setAttachementCount()
     * @uses TripReportTrailerSummary::setTotalDuration()
     * @uses TripReportTrailerSummary::setTotalDistance()
     * @uses TripReportTrailerSummary::setTotalConsumption()
     * @uses TripReportTrailerSummary::setTrailer()
     * @uses TripReportTrailerSummary::setTrailer_External()
     * @param int $attachementCount
     * @param float $totalDuration
     * @param float $totalDistance
     * @param float $totalConsumption
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param string $trailer_External
     */
    public function __construct($attachementCount = null, $totalDuration = null, $totalDistance = null, $totalConsumption = null, \StructType\IdentifierVehicleResult $trailer = null, $trailer_External = null)
    {
        $this
            ->setAttachementCount($attachementCount)
            ->setTotalDuration($totalDuration)
            ->setTotalDistance($totalDistance)
            ->setTotalConsumption($totalConsumption)
            ->setTrailer($trailer)
            ->setTrailer_External($trailer_External);
    }
    /**
     * Get AttachementCount value
     * @return int
     */
    public function getAttachementCount()
    {
        return $this->AttachementCount;
    }
    /**
     * Set AttachementCount value
     * @param int $attachementCount
     * @return \StructType\TripReportTrailerSummary
     */
    public function setAttachementCount($attachementCount = null)
    {
        // validation for constraint: int
        if (!is_null($attachementCount) && !(is_int($attachementCount) || ctype_digit($attachementCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attachementCount, true), gettype($attachementCount)), __LINE__);
        }
        $this->AttachementCount = $attachementCount;
        return $this;
    }
    /**
     * Get TotalDuration value
     * @return float
     */
    public function getTotalDuration()
    {
        return $this->TotalDuration;
    }
    /**
     * Set TotalDuration value
     * @param float $totalDuration
     * @return \StructType\TripReportTrailerSummary
     */
    public function setTotalDuration($totalDuration = null)
    {
        // validation for constraint: float
        if (!is_null($totalDuration) && !(is_float($totalDuration) || is_numeric($totalDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDuration, true), gettype($totalDuration)), __LINE__);
        }
        $this->TotalDuration = $totalDuration;
        return $this;
    }
    /**
     * Get TotalDistance value
     * @return float
     */
    public function getTotalDistance()
    {
        return $this->TotalDistance;
    }
    /**
     * Set TotalDistance value
     * @param float $totalDistance
     * @return \StructType\TripReportTrailerSummary
     */
    public function setTotalDistance($totalDistance = null)
    {
        // validation for constraint: float
        if (!is_null($totalDistance) && !(is_float($totalDistance) || is_numeric($totalDistance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDistance, true), gettype($totalDistance)), __LINE__);
        }
        $this->TotalDistance = $totalDistance;
        return $this;
    }
    /**
     * Get TotalConsumption value
     * @return float
     */
    public function getTotalConsumption()
    {
        return $this->TotalConsumption;
    }
    /**
     * Set TotalConsumption value
     * @param float $totalConsumption
     * @return \StructType\TripReportTrailerSummary
     */
    public function setTotalConsumption($totalConsumption = null)
    {
        // validation for constraint: float
        if (!is_null($totalConsumption) && !(is_float($totalConsumption) || is_numeric($totalConsumption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalConsumption, true), gettype($totalConsumption)), __LINE__);
        }
        $this->TotalConsumption = $totalConsumption;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\TripReportTrailerSummary
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Trailer_External value
     * @return string|null
     */
    public function getTrailer_External()
    {
        return $this->Trailer_External;
    }
    /**
     * Set Trailer_External value
     * @param string $trailer_External
     * @return \StructType\TripReportTrailerSummary
     */
    public function setTrailer_External($trailer_External = null)
    {
        // validation for constraint: string
        if (!is_null($trailer_External) && !is_string($trailer_External)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailer_External, true), gettype($trailer_External)), __LINE__);
        }
        $this->Trailer_External = $trailer_External;
        return $this;
    }
}
