<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripItemResult_v3 StructType
 * @subpackage Structs
 */
class TripItemResult_v3 extends Trip
{
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The TransferStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TransferStatus;
    /**
     * The ExternalSynchStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExternalSynchStatus;
    /**
     * The CancelStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CancelStatus;
    /**
     * The TransicsTripID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsTripID;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * The Places
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPlaceIdentifier_V2
     */
    public $Places;
    /**
     * The TachoActivities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTachoActivity
     */
    public $TachoActivities;
    /**
     * The Registrations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRegistration_v2
     */
    public $Registrations;
    /**
     * Constructor method for TripItemResult_v3
     * @uses TripItemResult_v3::setStartDate()
     * @uses TripItemResult_v3::setEndDate()
     * @uses TripItemResult_v3::setModificationDate()
     * @uses TripItemResult_v3::setStatus()
     * @uses TripItemResult_v3::setTransferStatus()
     * @uses TripItemResult_v3::setExternalSynchStatus()
     * @uses TripItemResult_v3::setCancelStatus()
     * @uses TripItemResult_v3::setTransicsTripID()
     * @uses TripItemResult_v3::setDriver()
     * @uses TripItemResult_v3::setVehicle()
     * @uses TripItemResult_v3::setAuthor()
     * @uses TripItemResult_v3::setPlaces()
     * @uses TripItemResult_v3::setTachoActivities()
     * @uses TripItemResult_v3::setRegistrations()
     * @param string $startDate
     * @param string $endDate
     * @param string $modificationDate
     * @param string $status
     * @param string $transferStatus
     * @param string $externalSynchStatus
     * @param string $cancelStatus
     * @param int $transicsTripID
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param string $author
     * @param \ArrayType\ArrayOfPlaceIdentifier_V2 $places
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @param \ArrayType\ArrayOfRegistration_v2 $registrations
     */
    public function __construct($startDate = null, $endDate = null, $modificationDate = null, $status = null, $transferStatus = null, $externalSynchStatus = null, $cancelStatus = null, $transicsTripID = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierVehicleResult $vehicle = null, $author = null, \ArrayType\ArrayOfPlaceIdentifier_V2 $places = null, \ArrayType\ArrayOfTachoActivity $tachoActivities = null, \ArrayType\ArrayOfRegistration_v2 $registrations = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setModificationDate($modificationDate)
            ->setStatus($status)
            ->setTransferStatus($transferStatus)
            ->setExternalSynchStatus($externalSynchStatus)
            ->setCancelStatus($cancelStatus)
            ->setTransicsTripID($transicsTripID)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setAuthor($author)
            ->setPlaces($places)
            ->setTachoActivities($tachoActivities)
            ->setRegistrations($registrations);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\TripItemResult_v3
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\TripItemResult_v3
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\TripItemResult_v3
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumPlanningStatus::valueIsValid()
     * @uses \EnumType\EnumPlanningStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\TripItemResult_v3
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\EnumPlanningStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TransferStatus value
     * @return string
     */
    public function getTransferStatus()
    {
        return $this->TransferStatus;
    }
    /**
     * Set TransferStatus value
     * @uses \EnumType\EnumTransferStatus::valueIsValid()
     * @uses \EnumType\EnumTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferStatus
     * @return \StructType\TripItemResult_v3
     */
    public function setTransferStatus($transferStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTransferStatus::valueIsValid($transferStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTransferStatus', is_array($transferStatus) ? implode(', ', $transferStatus) : var_export($transferStatus, true), implode(', ', \EnumType\EnumTransferStatus::getValidValues())), __LINE__);
        }
        $this->TransferStatus = $transferStatus;
        return $this;
    }
    /**
     * Get ExternalSynchStatus value
     * @return string
     */
    public function getExternalSynchStatus()
    {
        return $this->ExternalSynchStatus;
    }
    /**
     * Set ExternalSynchStatus value
     * @uses \EnumType\EnumSynchronisationStatus::valueIsValid()
     * @uses \EnumType\EnumSynchronisationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $externalSynchStatus
     * @return \StructType\TripItemResult_v3
     */
    public function setExternalSynchStatus($externalSynchStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSynchronisationStatus::valueIsValid($externalSynchStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSynchronisationStatus', is_array($externalSynchStatus) ? implode(', ', $externalSynchStatus) : var_export($externalSynchStatus, true), implode(', ', \EnumType\EnumSynchronisationStatus::getValidValues())), __LINE__);
        }
        $this->ExternalSynchStatus = $externalSynchStatus;
        return $this;
    }
    /**
     * Get CancelStatus value
     * @return string
     */
    public function getCancelStatus()
    {
        return $this->CancelStatus;
    }
    /**
     * Set CancelStatus value
     * @uses \EnumType\EnumCancelStatus::valueIsValid()
     * @uses \EnumType\EnumCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelStatus
     * @return \StructType\TripItemResult_v3
     */
    public function setCancelStatus($cancelStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCancelStatus::valueIsValid($cancelStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumCancelStatus', is_array($cancelStatus) ? implode(', ', $cancelStatus) : var_export($cancelStatus, true), implode(', ', \EnumType\EnumCancelStatus::getValidValues())), __LINE__);
        }
        $this->CancelStatus = $cancelStatus;
        return $this;
    }
    /**
     * Get TransicsTripID value
     * @return int
     */
    public function getTransicsTripID()
    {
        return $this->TransicsTripID;
    }
    /**
     * Set TransicsTripID value
     * @param int $transicsTripID
     * @return \StructType\TripItemResult_v3
     */
    public function setTransicsTripID($transicsTripID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsTripID) && !(is_int($transicsTripID) || ctype_digit($transicsTripID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transicsTripID, true), gettype($transicsTripID)), __LINE__);
        }
        $this->TransicsTripID = $transicsTripID;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\TripItemResult_v3
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\TripItemResult_v3
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\TripItemResult_v3
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get Places value
     * @return \ArrayType\ArrayOfPlaceIdentifier_V2|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param \ArrayType\ArrayOfPlaceIdentifier_V2 $places
     * @return \StructType\TripItemResult_v3
     */
    public function setPlaces(\ArrayType\ArrayOfPlaceIdentifier_V2 $places = null)
    {
        $this->Places = $places;
        return $this;
    }
    /**
     * Get TachoActivities value
     * @return \ArrayType\ArrayOfTachoActivity|null
     */
    public function getTachoActivities()
    {
        return $this->TachoActivities;
    }
    /**
     * Set TachoActivities value
     * @param \ArrayType\ArrayOfTachoActivity $tachoActivities
     * @return \StructType\TripItemResult_v3
     */
    public function setTachoActivities(\ArrayType\ArrayOfTachoActivity $tachoActivities = null)
    {
        $this->TachoActivities = $tachoActivities;
        return $this;
    }
    /**
     * Get Registrations value
     * @return \ArrayType\ArrayOfRegistration_v2|null
     */
    public function getRegistrations()
    {
        return $this->Registrations;
    }
    /**
     * Set Registrations value
     * @param \ArrayType\ArrayOfRegistration_v2 $registrations
     * @return \StructType\TripItemResult_v3
     */
    public function setRegistrations(\ArrayType\ArrayOfRegistration_v2 $registrations = null)
    {
        $this->Registrations = $registrations;
        return $this;
    }
}
