<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripItemResult_V5 StructType
 * @subpackage Structs
 */
class TripItemResult_V5 extends TripItemResult_V4
{
    /**
     * The TripStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TripStatus;
    /**
     * Constructor method for TripItemResult_V5
     * @uses TripItemResult_V5::setTripStatus()
     * @param string $tripStatus
     */
    public function __construct($tripStatus = null)
    {
        $this
            ->setTripStatus($tripStatus);
    }
    /**
     * Get TripStatus value
     * @return string
     */
    public function getTripStatus()
    {
        return $this->TripStatus;
    }
    /**
     * Set TripStatus value
     * @uses \EnumType\EnumTripStatus::valueIsValid()
     * @uses \EnumType\EnumTripStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tripStatus
     * @return \StructType\TripItemResult_V5
     */
    public function setTripStatus($tripStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTripStatus::valueIsValid($tripStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTripStatus', is_array($tripStatus) ? implode(', ', $tripStatus) : var_export($tripStatus, true), implode(', ', \EnumType\EnumTripStatus::getValidValues())), __LINE__);
        }
        $this->TripStatus = $tripStatus;
        return $this;
    }
}
