<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrailerResult_V6 StructType
 * @subpackage Structs
 */
class TrailerResult_V6 extends Trailer
{
    /**
     * The TrailerTransicsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TrailerTransicsID;
    /**
     * The Modified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modified;
    /**
     * The CurrentKms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurrentKms;
    /**
     * The FuelLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevel;
    /**
     * The FuelLevelIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuelLevelIndex;
    /**
     * The RefrigeratorIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RefrigeratorIndex;
    /**
     * The ActivityCompleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ActivityCompleted;
    /**
     * The TrailerRecognition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrailerRecognition;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The ObcInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerObcInfo_V2
     */
    public $ObcInfo;
    /**
     * The ETAInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerETAInfo
     */
    public $ETAInfo;
    /**
     * The TemperatureInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerTemperatureInfo_V2
     */
    public $TemperatureInfo;
    /**
     * The InfoFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerInfoFields
     */
    public $InfoFields;
    /**
     * The VehicleCostInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TrailerCostInfo
     */
    public $VehicleCostInfo;
    /**
     * The NextStopInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NextStopResult
     */
    public $NextStopInfo;
    /**
     * The FormattedTrailerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedTrailerName;
    /**
     * The UpdateDatesList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUpdateDatesItem
     */
    public $UpdateDatesList;
    /**
     * Constructor method for TrailerResult_V6
     * @uses TrailerResult_V6::setTrailerTransicsID()
     * @uses TrailerResult_V6::setModified()
     * @uses TrailerResult_V6::setCurrentKms()
     * @uses TrailerResult_V6::setFuelLevel()
     * @uses TrailerResult_V6::setFuelLevelIndex()
     * @uses TrailerResult_V6::setRefrigeratorIndex()
     * @uses TrailerResult_V6::setActivityCompleted()
     * @uses TrailerResult_V6::setTrailerRecognition()
     * @uses TrailerResult_V6::setPosition()
     * @uses TrailerResult_V6::setActivity()
     * @uses TrailerResult_V6::setDriver()
     * @uses TrailerResult_V6::setCoDriver()
     * @uses TrailerResult_V6::setVehicle()
     * @uses TrailerResult_V6::setObcInfo()
     * @uses TrailerResult_V6::setETAInfo()
     * @uses TrailerResult_V6::setTemperatureInfo()
     * @uses TrailerResult_V6::setInfoFields()
     * @uses TrailerResult_V6::setVehicleCostInfo()
     * @uses TrailerResult_V6::setNextStopInfo()
     * @uses TrailerResult_V6::setFormattedTrailerName()
     * @uses TrailerResult_V6::setUpdateDatesList()
     * @param int $trailerTransicsID
     * @param string $modified
     * @param int $currentKms
     * @param int $fuelLevel
     * @param int $fuelLevelIndex
     * @param int $refrigeratorIndex
     * @param bool $activityCompleted
     * @param string $trailerRecognition
     * @param \StructType\PositionResult $position
     * @param \StructType\Activity $activity
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\TrailerObcInfo_V2 $obcInfo
     * @param \StructType\TrailerETAInfo $eTAInfo
     * @param \StructType\TrailerTemperatureInfo_V2 $temperatureInfo
     * @param \StructType\TrailerInfoFields $infoFields
     * @param \StructType\TrailerCostInfo $vehicleCostInfo
     * @param \StructType\NextStopResult $nextStopInfo
     * @param string $formattedTrailerName
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     */
    public function __construct($trailerTransicsID = null, $modified = null, $currentKms = null, $fuelLevel = null, $fuelLevelIndex = null, $refrigeratorIndex = null, $activityCompleted = null, $trailerRecognition = null, \StructType\PositionResult $position = null, \StructType\Activity $activity = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\IdentifierPerson_V2 $coDriver = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\TrailerObcInfo_V2 $obcInfo = null, \StructType\TrailerETAInfo $eTAInfo = null, \StructType\TrailerTemperatureInfo_V2 $temperatureInfo = null, \StructType\TrailerInfoFields $infoFields = null, \StructType\TrailerCostInfo $vehicleCostInfo = null, \StructType\NextStopResult $nextStopInfo = null, $formattedTrailerName = null, \ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null)
    {
        $this
            ->setTrailerTransicsID($trailerTransicsID)
            ->setModified($modified)
            ->setCurrentKms($currentKms)
            ->setFuelLevel($fuelLevel)
            ->setFuelLevelIndex($fuelLevelIndex)
            ->setRefrigeratorIndex($refrigeratorIndex)
            ->setActivityCompleted($activityCompleted)
            ->setTrailerRecognition($trailerRecognition)
            ->setPosition($position)
            ->setActivity($activity)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setVehicle($vehicle)
            ->setObcInfo($obcInfo)
            ->setETAInfo($eTAInfo)
            ->setTemperatureInfo($temperatureInfo)
            ->setInfoFields($infoFields)
            ->setVehicleCostInfo($vehicleCostInfo)
            ->setNextStopInfo($nextStopInfo)
            ->setFormattedTrailerName($formattedTrailerName)
            ->setUpdateDatesList($updateDatesList);
    }
    /**
     * Get TrailerTransicsID value
     * @return int
     */
    public function getTrailerTransicsID()
    {
        return $this->TrailerTransicsID;
    }
    /**
     * Set TrailerTransicsID value
     * @param int $trailerTransicsID
     * @return \StructType\TrailerResult_V6
     */
    public function setTrailerTransicsID($trailerTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($trailerTransicsID) && !(is_int($trailerTransicsID) || ctype_digit($trailerTransicsID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trailerTransicsID, true), gettype($trailerTransicsID)), __LINE__);
        }
        $this->TrailerTransicsID = $trailerTransicsID;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \StructType\TrailerResult_V6
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modified, true), gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get CurrentKms value
     * @return int
     */
    public function getCurrentKms()
    {
        return $this->CurrentKms;
    }
    /**
     * Set CurrentKms value
     * @param int $currentKms
     * @return \StructType\TrailerResult_V6
     */
    public function setCurrentKms($currentKms = null)
    {
        // validation for constraint: int
        if (!is_null($currentKms) && !(is_int($currentKms) || ctype_digit($currentKms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentKms, true), gettype($currentKms)), __LINE__);
        }
        $this->CurrentKms = $currentKms;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\TrailerResult_V6
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !(is_int($fuelLevel) || ctype_digit($fuelLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelLevel, true), gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get FuelLevelIndex value
     * @return int
     */
    public function getFuelLevelIndex()
    {
        return $this->FuelLevelIndex;
    }
    /**
     * Set FuelLevelIndex value
     * @param int $fuelLevelIndex
     * @return \StructType\TrailerResult_V6
     */
    public function setFuelLevelIndex($fuelLevelIndex = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevelIndex) && !(is_int($fuelLevelIndex) || ctype_digit($fuelLevelIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelLevelIndex, true), gettype($fuelLevelIndex)), __LINE__);
        }
        $this->FuelLevelIndex = $fuelLevelIndex;
        return $this;
    }
    /**
     * Get RefrigeratorIndex value
     * @return int
     */
    public function getRefrigeratorIndex()
    {
        return $this->RefrigeratorIndex;
    }
    /**
     * Set RefrigeratorIndex value
     * @param int $refrigeratorIndex
     * @return \StructType\TrailerResult_V6
     */
    public function setRefrigeratorIndex($refrigeratorIndex = null)
    {
        // validation for constraint: int
        if (!is_null($refrigeratorIndex) && !(is_int($refrigeratorIndex) || ctype_digit($refrigeratorIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refrigeratorIndex, true), gettype($refrigeratorIndex)), __LINE__);
        }
        $this->RefrigeratorIndex = $refrigeratorIndex;
        return $this;
    }
    /**
     * Get ActivityCompleted value
     * @return bool
     */
    public function getActivityCompleted()
    {
        return $this->ActivityCompleted;
    }
    /**
     * Set ActivityCompleted value
     * @param bool $activityCompleted
     * @return \StructType\TrailerResult_V6
     */
    public function setActivityCompleted($activityCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($activityCompleted) && !is_bool($activityCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activityCompleted, true), gettype($activityCompleted)), __LINE__);
        }
        $this->ActivityCompleted = $activityCompleted;
        return $this;
    }
    /**
     * Get TrailerRecognition value
     * @return string|null
     */
    public function getTrailerRecognition()
    {
        return $this->TrailerRecognition;
    }
    /**
     * Set TrailerRecognition value
     * @param string $trailerRecognition
     * @return \StructType\TrailerResult_V6
     */
    public function setTrailerRecognition($trailerRecognition = null)
    {
        // validation for constraint: string
        if (!is_null($trailerRecognition) && !is_string($trailerRecognition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trailerRecognition, true), gettype($trailerRecognition)), __LINE__);
        }
        $this->TrailerRecognition = $trailerRecognition;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\TrailerResult_V6
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\TrailerResult_V6
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\TrailerResult_V6
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\TrailerResult_V6
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\TrailerResult_V6
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get ObcInfo value
     * @return \StructType\TrailerObcInfo_V2|null
     */
    public function getObcInfo()
    {
        return $this->ObcInfo;
    }
    /**
     * Set ObcInfo value
     * @param \StructType\TrailerObcInfo_V2 $obcInfo
     * @return \StructType\TrailerResult_V6
     */
    public function setObcInfo(\StructType\TrailerObcInfo_V2 $obcInfo = null)
    {
        $this->ObcInfo = $obcInfo;
        return $this;
    }
    /**
     * Get ETAInfo value
     * @return \StructType\TrailerETAInfo|null
     */
    public function getETAInfo()
    {
        return $this->ETAInfo;
    }
    /**
     * Set ETAInfo value
     * @param \StructType\TrailerETAInfo $eTAInfo
     * @return \StructType\TrailerResult_V6
     */
    public function setETAInfo(\StructType\TrailerETAInfo $eTAInfo = null)
    {
        $this->ETAInfo = $eTAInfo;
        return $this;
    }
    /**
     * Get TemperatureInfo value
     * @return \StructType\TrailerTemperatureInfo_V2|null
     */
    public function getTemperatureInfo()
    {
        return $this->TemperatureInfo;
    }
    /**
     * Set TemperatureInfo value
     * @param \StructType\TrailerTemperatureInfo_V2 $temperatureInfo
     * @return \StructType\TrailerResult_V6
     */
    public function setTemperatureInfo(\StructType\TrailerTemperatureInfo_V2 $temperatureInfo = null)
    {
        $this->TemperatureInfo = $temperatureInfo;
        return $this;
    }
    /**
     * Get InfoFields value
     * @return \StructType\TrailerInfoFields|null
     */
    public function getInfoFields()
    {
        return $this->InfoFields;
    }
    /**
     * Set InfoFields value
     * @param \StructType\TrailerInfoFields $infoFields
     * @return \StructType\TrailerResult_V6
     */
    public function setInfoFields(\StructType\TrailerInfoFields $infoFields = null)
    {
        $this->InfoFields = $infoFields;
        return $this;
    }
    /**
     * Get VehicleCostInfo value
     * @return \StructType\TrailerCostInfo|null
     */
    public function getVehicleCostInfo()
    {
        return $this->VehicleCostInfo;
    }
    /**
     * Set VehicleCostInfo value
     * @param \StructType\TrailerCostInfo $vehicleCostInfo
     * @return \StructType\TrailerResult_V6
     */
    public function setVehicleCostInfo(\StructType\TrailerCostInfo $vehicleCostInfo = null)
    {
        $this->VehicleCostInfo = $vehicleCostInfo;
        return $this;
    }
    /**
     * Get NextStopInfo value
     * @return \StructType\NextStopResult|null
     */
    public function getNextStopInfo()
    {
        return $this->NextStopInfo;
    }
    /**
     * Set NextStopInfo value
     * @param \StructType\NextStopResult $nextStopInfo
     * @return \StructType\TrailerResult_V6
     */
    public function setNextStopInfo(\StructType\NextStopResult $nextStopInfo = null)
    {
        $this->NextStopInfo = $nextStopInfo;
        return $this;
    }
    /**
     * Get FormattedTrailerName value
     * @return string|null
     */
    public function getFormattedTrailerName()
    {
        return $this->FormattedTrailerName;
    }
    /**
     * Set FormattedTrailerName value
     * @param string $formattedTrailerName
     * @return \StructType\TrailerResult_V6
     */
    public function setFormattedTrailerName($formattedTrailerName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedTrailerName) && !is_string($formattedTrailerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedTrailerName, true), gettype($formattedTrailerName)), __LINE__);
        }
        $this->FormattedTrailerName = $formattedTrailerName;
        return $this;
    }
    /**
     * Get UpdateDatesList value
     * @return \ArrayType\ArrayOfUpdateDatesItem|null
     */
    public function getUpdateDatesList()
    {
        return $this->UpdateDatesList;
    }
    /**
     * Set UpdateDatesList value
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     * @return \StructType\TrailerResult_V6
     */
    public function setUpdateDatesList(\ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null)
    {
        $this->UpdateDatesList = $updateDatesList;
        return $this;
    }
}
