<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextMessageInbox StructType
 * @subpackage Structs
 */
class TextMessageInbox extends TextMessage
{
    /**
     * The ReadDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReadDate;
    /**
     * The Read
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Read;
    /**
     * The TextMessageID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TextMessageID;
    /**
     * The KmVehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $KmVehicle;
    /**
     * The DeliveredDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeliveredDate;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The ModifiedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModifiedDate;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The FuellevelVehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FuellevelVehicle;
    /**
     * The InterfaceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $InterfaceInfo;
    /**
     * The ForceOBCWakeUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ForceOBCWakeUp;
    /**
     * The GsmNr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GsmNr;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The PreviousReplies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTextMessageInbox
     */
    public $PreviousReplies;
    /**
     * The OutboxMessageRepliedFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TextMessageOutbox
     */
    public $OutboxMessageRepliedFrom;
    /**
     * Constructor method for TextMessageInbox
     * @uses TextMessageInbox::setReadDate()
     * @uses TextMessageInbox::setRead()
     * @uses TextMessageInbox::setTextMessageID()
     * @uses TextMessageInbox::setKmVehicle()
     * @uses TextMessageInbox::setDeliveredDate()
     * @uses TextMessageInbox::setCreationDate()
     * @uses TextMessageInbox::setModifiedDate()
     * @uses TextMessageInbox::setArrivalDateTime()
     * @uses TextMessageInbox::setFuellevelVehicle()
     * @uses TextMessageInbox::setInterfaceInfo()
     * @uses TextMessageInbox::setForceOBCWakeUp()
     * @uses TextMessageInbox::setGsmNr()
     * @uses TextMessageInbox::setActivity()
     * @uses TextMessageInbox::setPosition()
     * @uses TextMessageInbox::setVehicle()
     * @uses TextMessageInbox::setTrailer()
     * @uses TextMessageInbox::setDriver()
     * @uses TextMessageInbox::setPreviousReplies()
     * @uses TextMessageInbox::setOutboxMessageRepliedFrom()
     * @param string $readDate
     * @param bool $read
     * @param int $textMessageID
     * @param int $kmVehicle
     * @param string $deliveredDate
     * @param string $creationDate
     * @param string $modifiedDate
     * @param string $arrivalDateTime
     * @param int $fuellevelVehicle
     * @param float $interfaceInfo
     * @param bool $forceOBCWakeUp
     * @param string $gsmNr
     * @param \StructType\Activity $activity
     * @param \StructType\PositionResult $position
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param \StructType\IdentifierPerson $driver
     * @param \ArrayType\ArrayOfTextMessageInbox $previousReplies
     * @param \StructType\TextMessageOutbox $outboxMessageRepliedFrom
     */
    public function __construct($readDate = null, $read = null, $textMessageID = null, $kmVehicle = null, $deliveredDate = null, $creationDate = null, $modifiedDate = null, $arrivalDateTime = null, $fuellevelVehicle = null, $interfaceInfo = null, $forceOBCWakeUp = null, $gsmNr = null, \StructType\Activity $activity = null, \StructType\PositionResult $position = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, \StructType\IdentifierPerson $driver = null, \ArrayType\ArrayOfTextMessageInbox $previousReplies = null, \StructType\TextMessageOutbox $outboxMessageRepliedFrom = null)
    {
        $this
            ->setReadDate($readDate)
            ->setRead($read)
            ->setTextMessageID($textMessageID)
            ->setKmVehicle($kmVehicle)
            ->setDeliveredDate($deliveredDate)
            ->setCreationDate($creationDate)
            ->setModifiedDate($modifiedDate)
            ->setArrivalDateTime($arrivalDateTime)
            ->setFuellevelVehicle($fuellevelVehicle)
            ->setInterfaceInfo($interfaceInfo)
            ->setForceOBCWakeUp($forceOBCWakeUp)
            ->setGsmNr($gsmNr)
            ->setActivity($activity)
            ->setPosition($position)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setPreviousReplies($previousReplies)
            ->setOutboxMessageRepliedFrom($outboxMessageRepliedFrom);
    }
    /**
     * Get ReadDate value
     * @return string
     */
    public function getReadDate()
    {
        return $this->ReadDate;
    }
    /**
     * Set ReadDate value
     * @param string $readDate
     * @return \StructType\TextMessageInbox
     */
    public function setReadDate($readDate = null)
    {
        // validation for constraint: string
        if (!is_null($readDate) && !is_string($readDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readDate, true), gettype($readDate)), __LINE__);
        }
        $this->ReadDate = $readDate;
        return $this;
    }
    /**
     * Get Read value
     * @return bool
     */
    public function getRead()
    {
        return $this->Read;
    }
    /**
     * Set Read value
     * @param bool $read
     * @return \StructType\TextMessageInbox
     */
    public function setRead($read = null)
    {
        // validation for constraint: boolean
        if (!is_null($read) && !is_bool($read)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($read, true), gettype($read)), __LINE__);
        }
        $this->Read = $read;
        return $this;
    }
    /**
     * Get TextMessageID value
     * @return int
     */
    public function getTextMessageID()
    {
        return $this->TextMessageID;
    }
    /**
     * Set TextMessageID value
     * @param int $textMessageID
     * @return \StructType\TextMessageInbox
     */
    public function setTextMessageID($textMessageID = null)
    {
        // validation for constraint: int
        if (!is_null($textMessageID) && !(is_int($textMessageID) || ctype_digit($textMessageID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($textMessageID, true), gettype($textMessageID)), __LINE__);
        }
        $this->TextMessageID = $textMessageID;
        return $this;
    }
    /**
     * Get KmVehicle value
     * @return int
     */
    public function getKmVehicle()
    {
        return $this->KmVehicle;
    }
    /**
     * Set KmVehicle value
     * @param int $kmVehicle
     * @return \StructType\TextMessageInbox
     */
    public function setKmVehicle($kmVehicle = null)
    {
        // validation for constraint: int
        if (!is_null($kmVehicle) && !(is_int($kmVehicle) || ctype_digit($kmVehicle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kmVehicle, true), gettype($kmVehicle)), __LINE__);
        }
        $this->KmVehicle = $kmVehicle;
        return $this;
    }
    /**
     * Get DeliveredDate value
     * @return string
     */
    public function getDeliveredDate()
    {
        return $this->DeliveredDate;
    }
    /**
     * Set DeliveredDate value
     * @param string $deliveredDate
     * @return \StructType\TextMessageInbox
     */
    public function setDeliveredDate($deliveredDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveredDate) && !is_string($deliveredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveredDate, true), gettype($deliveredDate)), __LINE__);
        }
        $this->DeliveredDate = $deliveredDate;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\TextMessageInbox
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\TextMessageInbox
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedDate, true), gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\TextMessageInbox
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get FuellevelVehicle value
     * @return int
     */
    public function getFuellevelVehicle()
    {
        return $this->FuellevelVehicle;
    }
    /**
     * Set FuellevelVehicle value
     * @param int $fuellevelVehicle
     * @return \StructType\TextMessageInbox
     */
    public function setFuellevelVehicle($fuellevelVehicle = null)
    {
        // validation for constraint: int
        if (!is_null($fuellevelVehicle) && !(is_int($fuellevelVehicle) || ctype_digit($fuellevelVehicle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuellevelVehicle, true), gettype($fuellevelVehicle)), __LINE__);
        }
        $this->FuellevelVehicle = $fuellevelVehicle;
        return $this;
    }
    /**
     * Get InterfaceInfo value
     * @return float
     */
    public function getInterfaceInfo()
    {
        return $this->InterfaceInfo;
    }
    /**
     * Set InterfaceInfo value
     * @param float $interfaceInfo
     * @return \StructType\TextMessageInbox
     */
    public function setInterfaceInfo($interfaceInfo = null)
    {
        // validation for constraint: float
        if (!is_null($interfaceInfo) && !(is_float($interfaceInfo) || is_numeric($interfaceInfo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($interfaceInfo, true), gettype($interfaceInfo)), __LINE__);
        }
        $this->InterfaceInfo = $interfaceInfo;
        return $this;
    }
    /**
     * Get ForceOBCWakeUp value
     * @return bool
     */
    public function getForceOBCWakeUp()
    {
        return $this->ForceOBCWakeUp;
    }
    /**
     * Set ForceOBCWakeUp value
     * @param bool $forceOBCWakeUp
     * @return \StructType\TextMessageInbox
     */
    public function setForceOBCWakeUp($forceOBCWakeUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceOBCWakeUp) && !is_bool($forceOBCWakeUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceOBCWakeUp, true), gettype($forceOBCWakeUp)), __LINE__);
        }
        $this->ForceOBCWakeUp = $forceOBCWakeUp;
        return $this;
    }
    /**
     * Get GsmNr value
     * @return string|null
     */
    public function getGsmNr()
    {
        return $this->GsmNr;
    }
    /**
     * Set GsmNr value
     * @param string $gsmNr
     * @return \StructType\TextMessageInbox
     */
    public function setGsmNr($gsmNr = null)
    {
        // validation for constraint: string
        if (!is_null($gsmNr) && !is_string($gsmNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gsmNr, true), gettype($gsmNr)), __LINE__);
        }
        $this->GsmNr = $gsmNr;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\TextMessageInbox
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\TextMessageInbox
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\TextMessageInbox
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\TextMessageInbox
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\TextMessageInbox
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get PreviousReplies value
     * @return \ArrayType\ArrayOfTextMessageInbox|null
     */
    public function getPreviousReplies()
    {
        return $this->PreviousReplies;
    }
    /**
     * Set PreviousReplies value
     * @param \ArrayType\ArrayOfTextMessageInbox $previousReplies
     * @return \StructType\TextMessageInbox
     */
    public function setPreviousReplies(\ArrayType\ArrayOfTextMessageInbox $previousReplies = null)
    {
        $this->PreviousReplies = $previousReplies;
        return $this;
    }
    /**
     * Get OutboxMessageRepliedFrom value
     * @return \StructType\TextMessageOutbox|null
     */
    public function getOutboxMessageRepliedFrom()
    {
        return $this->OutboxMessageRepliedFrom;
    }
    /**
     * Set OutboxMessageRepliedFrom value
     * @param \StructType\TextMessageOutbox $outboxMessageRepliedFrom
     * @return \StructType\TextMessageInbox
     */
    public function setOutboxMessageRepliedFrom(\StructType\TextMessageOutbox $outboxMessageRepliedFrom = null)
    {
        $this->OutboxMessageRepliedFrom = $outboxMessageRepliedFrom;
        return $this;
    }
}
