<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Temperature StructType
 * @subpackage Structs
 */
class Temperature extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The Minimum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Minimum;
    /**
     * The Maximum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Maximum;
    /**
     * Constructor method for Temperature
     * @uses Temperature::setValue()
     * @uses Temperature::setMinimum()
     * @uses Temperature::setMaximum()
     * @param float $value
     * @param float $minimum
     * @param float $maximum
     */
    public function __construct($value = null, $minimum = null, $maximum = null)
    {
        $this
            ->setValue($value)
            ->setMinimum($minimum)
            ->setMaximum($maximum);
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\Temperature
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Minimum value
     * @return float
     */
    public function getMinimum()
    {
        return $this->Minimum;
    }
    /**
     * Set Minimum value
     * @param float $minimum
     * @return \StructType\Temperature
     */
    public function setMinimum($minimum = null)
    {
        // validation for constraint: float
        if (!is_null($minimum) && !(is_float($minimum) || is_numeric($minimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum, true), gettype($minimum)), __LINE__);
        }
        $this->Minimum = $minimum;
        return $this;
    }
    /**
     * Get Maximum value
     * @return float
     */
    public function getMaximum()
    {
        return $this->Maximum;
    }
    /**
     * Set Maximum value
     * @param float $maximum
     * @return \StructType\Temperature
     */
    public function setMaximum($maximum = null)
    {
        // validation for constraint: float
        if (!is_null($maximum) && !(is_float($maximum) || is_numeric($maximum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximum, true), gettype($maximum)), __LINE__);
        }
        $this->Maximum = $maximum;
        return $this;
    }
}
