<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelemetricDataItem_V3 StructType
 * @subpackage Structs
 */
class TelemetricDataItem_V3 extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The Kilometers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Kilometers;
    /**
     * The Speed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Speed;
    /**
     * The DateReceived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateReceived;
    /**
     * The SynchronizationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SynchronizationDate;
    /**
     * The SynchronizationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SynchronizationId;
    /**
     * The Ignition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactObject
     */
    public $Ignition;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierTrailerResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The GenericList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGenericItemActual
     */
    public $GenericList;
    /**
     * The Temperatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TemperatureObjectActual
     */
    public $Temperatures;
    /**
     * The TachoInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $TachoInfo;
    /**
     * The EBS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EbsObjectActual
     */
    public $EBS;
    /**
     * The Reefer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReeferObjectActual
     */
    public $Reefer;
    /**
     * The DoorContacts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DoorContactsActual
     */
    public $DoorContacts;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for TelemetricDataItem_V3
     * @uses TelemetricDataItem_V3::setDate()
     * @uses TelemetricDataItem_V3::setKilometers()
     * @uses TelemetricDataItem_V3::setSpeed()
     * @uses TelemetricDataItem_V3::setDateReceived()
     * @uses TelemetricDataItem_V3::setSynchronizationDate()
     * @uses TelemetricDataItem_V3::setSynchronizationId()
     * @uses TelemetricDataItem_V3::setIgnition()
     * @uses TelemetricDataItem_V3::setVehicle()
     * @uses TelemetricDataItem_V3::setTrailer()
     * @uses TelemetricDataItem_V3::setDriver()
     * @uses TelemetricDataItem_V3::setPosition()
     * @uses TelemetricDataItem_V3::setGenericList()
     * @uses TelemetricDataItem_V3::setTemperatures()
     * @uses TelemetricDataItem_V3::setTachoInfo()
     * @uses TelemetricDataItem_V3::setEBS()
     * @uses TelemetricDataItem_V3::setReefer()
     * @uses TelemetricDataItem_V3::setDoorContacts()
     * @uses TelemetricDataItem_V3::setId()
     * @param string $date
     * @param int $kilometers
     * @param float $speed
     * @param string $dateReceived
     * @param string $synchronizationDate
     * @param int $synchronizationId
     * @param \StructType\ContactObject $ignition
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierTrailerResult $trailer
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\PositionResult $position
     * @param \ArrayType\ArrayOfGenericItemActual $genericList
     * @param \StructType\TemperatureObjectActual $temperatures
     * @param \StructType\CodeInfo $tachoInfo
     * @param \StructType\EbsObjectActual $eBS
     * @param \StructType\ReeferObjectActual $reefer
     * @param \StructType\DoorContactsActual $doorContacts
     * @param string $id
     */
    public function __construct($date = null, $kilometers = null, $speed = null, $dateReceived = null, $synchronizationDate = null, $synchronizationId = null, \StructType\ContactObject $ignition = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierTrailerResult $trailer = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\PositionResult $position = null, \ArrayType\ArrayOfGenericItemActual $genericList = null, \StructType\TemperatureObjectActual $temperatures = null, \StructType\CodeInfo $tachoInfo = null, \StructType\EbsObjectActual $eBS = null, \StructType\ReeferObjectActual $reefer = null, \StructType\DoorContactsActual $doorContacts = null, $id = null)
    {
        $this
            ->setDate($date)
            ->setKilometers($kilometers)
            ->setSpeed($speed)
            ->setDateReceived($dateReceived)
            ->setSynchronizationDate($synchronizationDate)
            ->setSynchronizationId($synchronizationId)
            ->setIgnition($ignition)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setPosition($position)
            ->setGenericList($genericList)
            ->setTemperatures($temperatures)
            ->setTachoInfo($tachoInfo)
            ->setEBS($eBS)
            ->setReefer($reefer)
            ->setDoorContacts($doorContacts)
            ->setId($id);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Kilometers value
     * @return int
     */
    public function getKilometers()
    {
        return $this->Kilometers;
    }
    /**
     * Set Kilometers value
     * @param int $kilometers
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setKilometers($kilometers = null)
    {
        // validation for constraint: int
        if (!is_null($kilometers) && !(is_int($kilometers) || ctype_digit($kilometers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kilometers, true), gettype($kilometers)), __LINE__);
        }
        $this->Kilometers = $kilometers;
        return $this;
    }
    /**
     * Get Speed value
     * @return float
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param float $speed
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: float
        if (!is_null($speed) && !(is_float($speed) || is_numeric($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get DateReceived value
     * @return string
     */
    public function getDateReceived()
    {
        return $this->DateReceived;
    }
    /**
     * Set DateReceived value
     * @param string $dateReceived
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setDateReceived($dateReceived = null)
    {
        // validation for constraint: string
        if (!is_null($dateReceived) && !is_string($dateReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateReceived, true), gettype($dateReceived)), __LINE__);
        }
        $this->DateReceived = $dateReceived;
        return $this;
    }
    /**
     * Get SynchronizationDate value
     * @return string
     */
    public function getSynchronizationDate()
    {
        return $this->SynchronizationDate;
    }
    /**
     * Set SynchronizationDate value
     * @param string $synchronizationDate
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setSynchronizationDate($synchronizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($synchronizationDate) && !is_string($synchronizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synchronizationDate, true), gettype($synchronizationDate)), __LINE__);
        }
        $this->SynchronizationDate = $synchronizationDate;
        return $this;
    }
    /**
     * Get SynchronizationId value
     * @return int
     */
    public function getSynchronizationId()
    {
        return $this->SynchronizationId;
    }
    /**
     * Set SynchronizationId value
     * @param int $synchronizationId
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setSynchronizationId($synchronizationId = null)
    {
        // validation for constraint: int
        if (!is_null($synchronizationId) && !(is_int($synchronizationId) || ctype_digit($synchronizationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($synchronizationId, true), gettype($synchronizationId)), __LINE__);
        }
        $this->SynchronizationId = $synchronizationId;
        return $this;
    }
    /**
     * Get Ignition value
     * @return \StructType\ContactObject|null
     */
    public function getIgnition()
    {
        return $this->Ignition;
    }
    /**
     * Set Ignition value
     * @param \StructType\ContactObject $ignition
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setIgnition(\StructType\ContactObject $ignition = null)
    {
        $this->Ignition = $ignition;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierTrailerResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierTrailerResult $trailer
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setTrailer(\StructType\IdentifierTrailerResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get GenericList value
     * @return \ArrayType\ArrayOfGenericItemActual|null
     */
    public function getGenericList()
    {
        return $this->GenericList;
    }
    /**
     * Set GenericList value
     * @param \ArrayType\ArrayOfGenericItemActual $genericList
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setGenericList(\ArrayType\ArrayOfGenericItemActual $genericList = null)
    {
        $this->GenericList = $genericList;
        return $this;
    }
    /**
     * Get Temperatures value
     * @return \StructType\TemperatureObjectActual|null
     */
    public function getTemperatures()
    {
        return $this->Temperatures;
    }
    /**
     * Set Temperatures value
     * @param \StructType\TemperatureObjectActual $temperatures
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setTemperatures(\StructType\TemperatureObjectActual $temperatures = null)
    {
        $this->Temperatures = $temperatures;
        return $this;
    }
    /**
     * Get TachoInfo value
     * @return \StructType\CodeInfo|null
     */
    public function getTachoInfo()
    {
        return $this->TachoInfo;
    }
    /**
     * Set TachoInfo value
     * @param \StructType\CodeInfo $tachoInfo
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setTachoInfo(\StructType\CodeInfo $tachoInfo = null)
    {
        $this->TachoInfo = $tachoInfo;
        return $this;
    }
    /**
     * Get EBS value
     * @return \StructType\EbsObjectActual|null
     */
    public function getEBS()
    {
        return $this->EBS;
    }
    /**
     * Set EBS value
     * @param \StructType\EbsObjectActual $eBS
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setEBS(\StructType\EbsObjectActual $eBS = null)
    {
        $this->EBS = $eBS;
        return $this;
    }
    /**
     * Get Reefer value
     * @return \StructType\ReeferObjectActual|null
     */
    public function getReefer()
    {
        return $this->Reefer;
    }
    /**
     * Set Reefer value
     * @param \StructType\ReeferObjectActual $reefer
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setReefer(\StructType\ReeferObjectActual $reefer = null)
    {
        $this->Reefer = $reefer;
        return $this;
    }
    /**
     * Get DoorContacts value
     * @return \StructType\DoorContactsActual|null
     */
    public function getDoorContacts()
    {
        return $this->DoorContacts;
    }
    /**
     * Set DoorContacts value
     * @param \StructType\DoorContactsActual $doorContacts
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setDoorContacts(\StructType\DoorContactsActual $doorContacts = null)
    {
        $this->DoorContacts = $doorContacts;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\TelemetricDataItem_V3
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
