<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TachoEvent StructType
 * @subpackage Structs
 */
class TachoEvent extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTime;
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModificationDate;
    /**
     * The Kilometers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Kilometers;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The WorkingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $WorkingCode;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * Constructor method for TachoEvent
     * @uses TachoEvent::setDateTime()
     * @uses TachoEvent::setModificationDate()
     * @uses TachoEvent::setKilometers()
     * @uses TachoEvent::setVehicle()
     * @uses TachoEvent::setWorkingCode()
     * @uses TachoEvent::setPosition()
     * @param string $dateTime
     * @param string $modificationDate
     * @param int $kilometers
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\CodeInfo $workingCode
     * @param \StructType\PositionResult $position
     */
    public function __construct($dateTime = null, $modificationDate = null, $kilometers = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\CodeInfo $workingCode = null, \StructType\PositionResult $position = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setModificationDate($modificationDate)
            ->setKilometers($kilometers)
            ->setVehicle($vehicle)
            ->setWorkingCode($workingCode)
            ->setPosition($position);
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\TachoEvent
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\TachoEvent
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get Kilometers value
     * @return int
     */
    public function getKilometers()
    {
        return $this->Kilometers;
    }
    /**
     * Set Kilometers value
     * @param int $kilometers
     * @return \StructType\TachoEvent
     */
    public function setKilometers($kilometers = null)
    {
        // validation for constraint: int
        if (!is_null($kilometers) && !(is_int($kilometers) || ctype_digit($kilometers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kilometers, true), gettype($kilometers)), __LINE__);
        }
        $this->Kilometers = $kilometers;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\TachoEvent
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get WorkingCode value
     * @return \StructType\CodeInfo|null
     */
    public function getWorkingCode()
    {
        return $this->WorkingCode;
    }
    /**
     * Set WorkingCode value
     * @param \StructType\CodeInfo $workingCode
     * @return \StructType\TachoEvent
     */
    public function setWorkingCode(\StructType\CodeInfo $workingCode = null)
    {
        $this->WorkingCode = $workingCode;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\TachoEvent
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
