<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StreetInfoResult StructType
 * @subpackage Structs
 */
class StreetInfoResult extends StreetInfo
{
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The StreetLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $StreetLevel;
    /**
     * Constructor method for StreetInfoResult
     * @uses StreetInfoResult::setLongitude()
     * @uses StreetInfoResult::setLatitude()
     * @uses StreetInfoResult::setStreetLevel()
     * @param float $longitude
     * @param float $latitude
     * @param bool $streetLevel
     */
    public function __construct($longitude = null, $latitude = null, $streetLevel = null)
    {
        $this
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setStreetLevel($streetLevel);
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\StreetInfoResult
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\StreetInfoResult
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get StreetLevel value
     * @return bool
     */
    public function getStreetLevel()
    {
        return $this->StreetLevel;
    }
    /**
     * Set StreetLevel value
     * @param bool $streetLevel
     * @return \StructType\StreetInfoResult
     */
    public function setStreetLevel($streetLevel = null)
    {
        // validation for constraint: boolean
        if (!is_null($streetLevel) && !is_bool($streetLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($streetLevel, true), gettype($streetLevel)), __LINE__);
        }
        $this->StreetLevel = $streetLevel;
        return $this;
    }
}
