<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SocialSubGroupItem StructType
 * @subpackage Structs
 */
class SocialSubGroupItem extends GroupBase
{
    /**
     * The ParentCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ParentCode;
    /**
     * The SocialSubChildList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSocialSubChildItem
     */
    public $SocialSubChildList;
    /**
     * Constructor method for SocialSubGroupItem
     * @uses SocialSubGroupItem::setParentCode()
     * @uses SocialSubGroupItem::setSocialSubChildList()
     * @param int $parentCode
     * @param \ArrayType\ArrayOfSocialSubChildItem $socialSubChildList
     */
    public function __construct($parentCode = null, \ArrayType\ArrayOfSocialSubChildItem $socialSubChildList = null)
    {
        $this
            ->setParentCode($parentCode)
            ->setSocialSubChildList($socialSubChildList);
    }
    /**
     * Get ParentCode value
     * @return int
     */
    public function getParentCode()
    {
        return $this->ParentCode;
    }
    /**
     * Set ParentCode value
     * @param int $parentCode
     * @return \StructType\SocialSubGroupItem
     */
    public function setParentCode($parentCode = null)
    {
        // validation for constraint: int
        if (!is_null($parentCode) && !(is_int($parentCode) || ctype_digit($parentCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentCode, true), gettype($parentCode)), __LINE__);
        }
        $this->ParentCode = $parentCode;
        return $this;
    }
    /**
     * Get SocialSubChildList value
     * @return \ArrayType\ArrayOfSocialSubChildItem|null
     */
    public function getSocialSubChildList()
    {
        return $this->SocialSubChildList;
    }
    /**
     * Set SocialSubChildList value
     * @param \ArrayType\ArrayOfSocialSubChildItem $socialSubChildList
     * @return \StructType\SocialSubGroupItem
     */
    public function setSocialSubChildList(\ArrayType\ArrayOfSocialSubChildItem $socialSubChildList = null)
    {
        $this->SocialSubChildList = $socialSubChildList;
        return $this;
    }
}
