<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendTextMessageResultInfo StructType
 * @subpackage Structs
 */
class SendTextMessageResultInfo extends AbstractStructBase
{
    /**
     * The MessageId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MessageId;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * Constructor method for SendTextMessageResultInfo
     * @uses SendTextMessageResultInfo::setMessageId()
     * @uses SendTextMessageResultInfo::setVehicle()
     * @param int $messageId
     * @param \StructType\IdentifierVehicleResult $vehicle
     */
    public function __construct($messageId = null, \StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this
            ->setMessageId($messageId)
            ->setVehicle($vehicle);
    }
    /**
     * Get MessageId value
     * @return int
     */
    public function getMessageId()
    {
        return $this->MessageId;
    }
    /**
     * Set MessageId value
     * @param int $messageId
     * @return \StructType\SendTextMessageResultInfo
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: int
        if (!is_null($messageId) && !(is_int($messageId) || ctype_digit($messageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messageId, true), gettype($messageId)), __LINE__);
        }
        $this->MessageId = $messageId;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\SendTextMessageResultInfo
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
}
