<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoleResult StructType
 * @subpackage Structs
 */
class RoleResult extends AbstractStructBase
{
    /**
     * The RoleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoleId;
    /**
     * The RoleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoleName;
    /**
     * The RoleDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoleDescription;
    /**
     * Constructor method for RoleResult
     * @uses RoleResult::setRoleId()
     * @uses RoleResult::setRoleName()
     * @uses RoleResult::setRoleDescription()
     * @param string $roleId
     * @param string $roleName
     * @param string $roleDescription
     */
    public function __construct($roleId = null, $roleName = null, $roleDescription = null)
    {
        $this
            ->setRoleId($roleId)
            ->setRoleName($roleName)
            ->setRoleDescription($roleDescription);
    }
    /**
     * Get RoleId value
     * @return string|null
     */
    public function getRoleId()
    {
        return $this->RoleId;
    }
    /**
     * Set RoleId value
     * @param string $roleId
     * @return \StructType\RoleResult
     */
    public function setRoleId($roleId = null)
    {
        // validation for constraint: string
        if (!is_null($roleId) && !is_string($roleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleId, true), gettype($roleId)), __LINE__);
        }
        $this->RoleId = $roleId;
        return $this;
    }
    /**
     * Get RoleName value
     * @return string|null
     */
    public function getRoleName()
    {
        return $this->RoleName;
    }
    /**
     * Set RoleName value
     * @param string $roleName
     * @return \StructType\RoleResult
     */
    public function setRoleName($roleName = null)
    {
        // validation for constraint: string
        if (!is_null($roleName) && !is_string($roleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleName, true), gettype($roleName)), __LINE__);
        }
        $this->RoleName = $roleName;
        return $this;
    }
    /**
     * Get RoleDescription value
     * @return string|null
     */
    public function getRoleDescription()
    {
        return $this->RoleDescription;
    }
    /**
     * Set RoleDescription value
     * @param string $roleDescription
     * @return \StructType\RoleResult
     */
    public function setRoleDescription($roleDescription = null)
    {
        // validation for constraint: string
        if (!is_null($roleDescription) && !is_string($roleDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleDescription, true), gettype($roleDescription)), __LINE__);
        }
        $this->RoleDescription = $roleDescription;
        return $this;
    }
}
