<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Refueling StructType
 * @subpackage Structs
 */
class Refueling extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTime;
    /**
     * The Liters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Liters;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The FullTank
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FullTank;
    /**
     * The Mileage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Mileage;
    /**
     * The FuelType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FuelType;
    /**
     * The LookupMileage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $LookupMileage;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Driver;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The Provider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierProvider
     */
    public $Provider;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FuelPosition
     */
    public $Position;
    /**
     * Constructor method for Refueling
     * @uses Refueling::setDateTime()
     * @uses Refueling::setLiters()
     * @uses Refueling::setPrice()
     * @uses Refueling::setFullTank()
     * @uses Refueling::setMileage()
     * @uses Refueling::setFuelType()
     * @uses Refueling::setLookupMileage()
     * @uses Refueling::setVehicle()
     * @uses Refueling::setDriver()
     * @uses Refueling::setCountryCode()
     * @uses Refueling::setProvider()
     * @uses Refueling::setPosition()
     * @param string $dateTime
     * @param float $liters
     * @param float $price
     * @param bool $fullTank
     * @param int $mileage
     * @param int $fuelType
     * @param bool $lookupMileage
     * @param \StructType\IdentifierVehicle $vehicle
     * @param \StructType\Identifier $driver
     * @param string $countryCode
     * @param \StructType\IdentifierProvider $provider
     * @param \StructType\FuelPosition $position
     */
    public function __construct($dateTime = null, $liters = null, $price = null, $fullTank = null, $mileage = null, $fuelType = null, $lookupMileage = null, \StructType\IdentifierVehicle $vehicle = null, \StructType\Identifier $driver = null, $countryCode = null, \StructType\IdentifierProvider $provider = null, \StructType\FuelPosition $position = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setLiters($liters)
            ->setPrice($price)
            ->setFullTank($fullTank)
            ->setMileage($mileage)
            ->setFuelType($fuelType)
            ->setLookupMileage($lookupMileage)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setCountryCode($countryCode)
            ->setProvider($provider)
            ->setPosition($position);
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\Refueling
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Liters value
     * @return float
     */
    public function getLiters()
    {
        return $this->Liters;
    }
    /**
     * Set Liters value
     * @param float $liters
     * @return \StructType\Refueling
     */
    public function setLiters($liters = null)
    {
        // validation for constraint: float
        if (!is_null($liters) && !(is_float($liters) || is_numeric($liters))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($liters, true), gettype($liters)), __LINE__);
        }
        $this->Liters = $liters;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\Refueling
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get FullTank value
     * @return bool
     */
    public function getFullTank()
    {
        return $this->FullTank;
    }
    /**
     * Set FullTank value
     * @param bool $fullTank
     * @return \StructType\Refueling
     */
    public function setFullTank($fullTank = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullTank) && !is_bool($fullTank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fullTank, true), gettype($fullTank)), __LINE__);
        }
        $this->FullTank = $fullTank;
        return $this;
    }
    /**
     * Get Mileage value
     * @return int
     */
    public function getMileage()
    {
        return $this->Mileage;
    }
    /**
     * Set Mileage value
     * @param int $mileage
     * @return \StructType\Refueling
     */
    public function setMileage($mileage = null)
    {
        // validation for constraint: int
        if (!is_null($mileage) && !(is_int($mileage) || ctype_digit($mileage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mileage, true), gettype($mileage)), __LINE__);
        }
        $this->Mileage = $mileage;
        return $this;
    }
    /**
     * Get FuelType value
     * @return int
     */
    public function getFuelType()
    {
        return $this->FuelType;
    }
    /**
     * Set FuelType value
     * @param int $fuelType
     * @return \StructType\Refueling
     */
    public function setFuelType($fuelType = null)
    {
        // validation for constraint: int
        if (!is_null($fuelType) && !(is_int($fuelType) || ctype_digit($fuelType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fuelType, true), gettype($fuelType)), __LINE__);
        }
        $this->FuelType = $fuelType;
        return $this;
    }
    /**
     * Get LookupMileage value
     * @return bool
     */
    public function getLookupMileage()
    {
        return $this->LookupMileage;
    }
    /**
     * Set LookupMileage value
     * @param bool $lookupMileage
     * @return \StructType\Refueling
     */
    public function setLookupMileage($lookupMileage = null)
    {
        // validation for constraint: boolean
        if (!is_null($lookupMileage) && !is_bool($lookupMileage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lookupMileage, true), gettype($lookupMileage)), __LINE__);
        }
        $this->LookupMileage = $lookupMileage;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\Refueling
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\Identifier|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\Identifier $driver
     * @return \StructType\Refueling
     */
    public function setDriver(\StructType\Identifier $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\Refueling
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get Provider value
     * @return \StructType\IdentifierProvider|null
     */
    public function getProvider()
    {
        return $this->Provider;
    }
    /**
     * Set Provider value
     * @param \StructType\IdentifierProvider $provider
     * @return \StructType\Refueling
     */
    public function setProvider(\StructType\IdentifierProvider $provider = null)
    {
        $this->Provider = $provider;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\FuelPosition|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\FuelPosition $position
     * @return \StructType\Refueling
     */
    public function setPosition(\StructType\FuelPosition $position = null)
    {
        $this->Position = $position;
        return $this;
    }
}
