<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileItem StructType
 * @subpackage Structs
 */
class ProfileItem extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProfileType;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Regulation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Regulation;
    /**
     * The Target
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Target;
    /**
     * Constructor method for ProfileItem
     * @uses ProfileItem::setId()
     * @uses ProfileItem::setProfileType()
     * @uses ProfileItem::setName()
     * @uses ProfileItem::setRegulation()
     * @uses ProfileItem::setTarget()
     * @param int $id
     * @param string $profileType
     * @param string $name
     * @param string $regulation
     * @param string $target
     */
    public function __construct($id = null, $profileType = null, $name = null, $regulation = null, $target = null)
    {
        $this
            ->setId($id)
            ->setProfileType($profileType)
            ->setName($name)
            ->setRegulation($regulation)
            ->setTarget($target);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ProfileItem
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @uses \EnumType\EnumProfileType::valueIsValid()
     * @uses \EnumType\EnumProfileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $profileType
     * @return \StructType\ProfileItem
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumProfileType::valueIsValid($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumProfileType', is_array($profileType) ? implode(', ', $profileType) : var_export($profileType, true), implode(', ', \EnumType\EnumProfileType::getValidValues())), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ProfileItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Regulation value
     * @return string|null
     */
    public function getRegulation()
    {
        return $this->Regulation;
    }
    /**
     * Set Regulation value
     * @param string $regulation
     * @return \StructType\ProfileItem
     */
    public function setRegulation($regulation = null)
    {
        // validation for constraint: string
        if (!is_null($regulation) && !is_string($regulation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regulation, true), gettype($regulation)), __LINE__);
        }
        $this->Regulation = $regulation;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\ProfileItem
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
}
