<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product_V2 StructType
 * @subpackage Structs
 */
class Product_V2 extends AbstractStructBase
{
    /**
     * The OrderSequence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderSequence;
    /**
     * The ProductID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductID;
    /**
     * The DriverDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDisplay;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Product_V2
     * @uses Product_V2::setOrderSequence()
     * @uses Product_V2::setProductID()
     * @uses Product_V2::setDriverDisplay()
     * @uses Product_V2::setComment()
     * @param int $orderSequence
     * @param string $productID
     * @param string $driverDisplay
     * @param string $comment
     */
    public function __construct($orderSequence = null, $productID = null, $driverDisplay = null, $comment = null)
    {
        $this
            ->setOrderSequence($orderSequence)
            ->setProductID($productID)
            ->setDriverDisplay($driverDisplay)
            ->setComment($comment);
    }
    /**
     * Get OrderSequence value
     * @return int
     */
    public function getOrderSequence()
    {
        return $this->OrderSequence;
    }
    /**
     * Set OrderSequence value
     * @param int $orderSequence
     * @return \StructType\Product_V2
     */
    public function setOrderSequence($orderSequence = null)
    {
        // validation for constraint: int
        if (!is_null($orderSequence) && !(is_int($orderSequence) || ctype_digit($orderSequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderSequence, true), gettype($orderSequence)), __LINE__);
        }
        $this->OrderSequence = $orderSequence;
        return $this;
    }
    /**
     * Get ProductID value
     * @return string|null
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param string $productID
     * @return \StructType\Product_V2
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: string
        if (!is_null($productID) && !is_string($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productID, true), gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get DriverDisplay value
     * @return string|null
     */
    public function getDriverDisplay()
    {
        return $this->DriverDisplay;
    }
    /**
     * Set DriverDisplay value
     * @param string $driverDisplay
     * @return \StructType\Product_V2
     */
    public function setDriverDisplay($driverDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($driverDisplay) && !is_string($driverDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverDisplay, true), gettype($driverDisplay)), __LINE__);
        }
        $this->DriverDisplay = $driverDisplay;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Product_V2
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
