<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Position_V2 StructType
 * @subpackage Structs
 */
class Position_V2 extends AbstractStructBase
{
    /**
     * The OrderSequence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderSequence;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Latitude;
    /**
     * Constructor method for Position_V2
     * @uses Position_V2::setOrderSequence()
     * @uses Position_V2::setLongitude()
     * @uses Position_V2::setLatitude()
     * @param int $orderSequence
     * @param float $longitude
     * @param float $latitude
     */
    public function __construct($orderSequence = null, $longitude = null, $latitude = null)
    {
        $this
            ->setOrderSequence($orderSequence)
            ->setLongitude($longitude)
            ->setLatitude($latitude);
    }
    /**
     * Get OrderSequence value
     * @return int
     */
    public function getOrderSequence()
    {
        return $this->OrderSequence;
    }
    /**
     * Set OrderSequence value
     * @param int $orderSequence
     * @return \StructType\Position_V2
     */
    public function setOrderSequence($orderSequence = null)
    {
        // validation for constraint: int
        if (!is_null($orderSequence) && !(is_int($orderSequence) || ctype_digit($orderSequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderSequence, true), gettype($orderSequence)), __LINE__);
        }
        $this->OrderSequence = $orderSequence;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\Position_V2
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\Position_V2
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
}
