<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningModificationsSelection_V3 StructType
 * @subpackage Structs
 */
class PlanningModificationsSelection_V3 extends AbstractStructBase
{
    /**
     * The PlanningSelectionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlanningSelectionType;
    /**
     * The SynchronizationSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SynchronizationSelection
     */
    public $SynchronizationSelection;
    /**
     * Constructor method for PlanningModificationsSelection_V3
     * @uses PlanningModificationsSelection_V3::setPlanningSelectionType()
     * @uses PlanningModificationsSelection_V3::setSynchronizationSelection()
     * @param string $planningSelectionType
     * @param \StructType\SynchronizationSelection $synchronizationSelection
     */
    public function __construct($planningSelectionType = null, \StructType\SynchronizationSelection $synchronizationSelection = null)
    {
        $this
            ->setPlanningSelectionType($planningSelectionType)
            ->setSynchronizationSelection($synchronizationSelection);
    }
    /**
     * Get PlanningSelectionType value
     * @return string
     */
    public function getPlanningSelectionType()
    {
        return $this->PlanningSelectionType;
    }
    /**
     * Set PlanningSelectionType value
     * @uses \EnumType\EnumPlanningSelectionModificationsType_V2::valueIsValid()
     * @uses \EnumType\EnumPlanningSelectionModificationsType_V2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $planningSelectionType
     * @return \StructType\PlanningModificationsSelection_V3
     */
    public function setPlanningSelectionType($planningSelectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningSelectionModificationsType_V2::valueIsValid($planningSelectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningSelectionModificationsType_V2', is_array($planningSelectionType) ? implode(', ', $planningSelectionType) : var_export($planningSelectionType, true), implode(', ', \EnumType\EnumPlanningSelectionModificationsType_V2::getValidValues())), __LINE__);
        }
        $this->PlanningSelectionType = $planningSelectionType;
        return $this;
    }
    /**
     * Get SynchronizationSelection value
     * @return \StructType\SynchronizationSelection|null
     */
    public function getSynchronizationSelection()
    {
        return $this->SynchronizationSelection;
    }
    /**
     * Set SynchronizationSelection value
     * @param \StructType\SynchronizationSelection $synchronizationSelection
     * @return \StructType\PlanningModificationsSelection_V3
     */
    public function setSynchronizationSelection(\StructType\SynchronizationSelection $synchronizationSelection = null)
    {
        $this->SynchronizationSelection = $synchronizationSelection;
        return $this;
    }
}
