<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanningItemSelection StructType
 * @subpackage Structs
 */
class PlanningItemSelection extends AbstractStructBase
{
    /**
     * The PlanningSelectionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlanningSelectionType;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The ParentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentID;
    /**
     * Constructor method for PlanningItemSelection
     * @uses PlanningItemSelection::setPlanningSelectionType()
     * @uses PlanningItemSelection::setID()
     * @uses PlanningItemSelection::setParentID()
     * @param string $planningSelectionType
     * @param string $iD
     * @param string $parentID
     */
    public function __construct($planningSelectionType = null, $iD = null, $parentID = null)
    {
        $this
            ->setPlanningSelectionType($planningSelectionType)
            ->setID($iD)
            ->setParentID($parentID);
    }
    /**
     * Get PlanningSelectionType value
     * @return string
     */
    public function getPlanningSelectionType()
    {
        return $this->PlanningSelectionType;
    }
    /**
     * Set PlanningSelectionType value
     * @uses \EnumType\EnumPlanningItemSelectionType::valueIsValid()
     * @uses \EnumType\EnumPlanningItemSelectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $planningSelectionType
     * @return \StructType\PlanningItemSelection
     */
    public function setPlanningSelectionType($planningSelectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlanningItemSelectionType::valueIsValid($planningSelectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumPlanningItemSelectionType', is_array($planningSelectionType) ? implode(', ', $planningSelectionType) : var_export($planningSelectionType, true), implode(', ', \EnumType\EnumPlanningItemSelectionType::getValidValues())), __LINE__);
        }
        $this->PlanningSelectionType = $planningSelectionType;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\PlanningItemSelection
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ParentID value
     * @return string|null
     */
    public function getParentID()
    {
        return $this->ParentID;
    }
    /**
     * Set ParentID value
     * @param string $parentID
     * @return \StructType\PlanningItemSelection
     */
    public function setParentID($parentID = null)
    {
        // validation for constraint: string
        if (!is_null($parentID) && !is_string($parentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentID, true), gettype($parentID)), __LINE__);
        }
        $this->ParentID = $parentID;
        return $this;
    }
}
