<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Planning StructType
 * @subpackage Structs
 */
abstract class Planning extends AbstractStructBase
{
    /**
     * The ActivateAutoNumbering
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ActivateAutoNumbering;
    /**
     * The TransferDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TransferDate;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * The Site
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierSite
     */
    public $Site;
    /**
     * Constructor method for Planning
     * @uses Planning::setActivateAutoNumbering()
     * @uses Planning::setTransferDate()
     * @uses Planning::setDriver()
     * @uses Planning::setVehicle()
     * @uses Planning::setSite()
     * @param bool $activateAutoNumbering
     * @param string $transferDate
     * @param \StructType\Identifier $driver
     * @param \StructType\IdentifierVehicle $vehicle
     * @param \StructType\IdentifierSite $site
     */
    public function __construct($activateAutoNumbering = null, $transferDate = null, \StructType\Identifier $driver = null, \StructType\IdentifierVehicle $vehicle = null, \StructType\IdentifierSite $site = null)
    {
        $this
            ->setActivateAutoNumbering($activateAutoNumbering)
            ->setTransferDate($transferDate)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setSite($site);
    }
    /**
     * Get ActivateAutoNumbering value
     * @return bool
     */
    public function getActivateAutoNumbering()
    {
        return $this->ActivateAutoNumbering;
    }
    /**
     * Set ActivateAutoNumbering value
     * @param bool $activateAutoNumbering
     * @return \StructType\Planning
     */
    public function setActivateAutoNumbering($activateAutoNumbering = null)
    {
        // validation for constraint: boolean
        if (!is_null($activateAutoNumbering) && !is_bool($activateAutoNumbering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activateAutoNumbering, true), gettype($activateAutoNumbering)), __LINE__);
        }
        $this->ActivateAutoNumbering = $activateAutoNumbering;
        return $this;
    }
    /**
     * Get TransferDate value
     * @return string
     */
    public function getTransferDate()
    {
        return $this->TransferDate;
    }
    /**
     * Set TransferDate value
     * @param string $transferDate
     * @return \StructType\Planning
     */
    public function setTransferDate($transferDate = null)
    {
        // validation for constraint: string
        if (!is_null($transferDate) && !is_string($transferDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferDate, true), gettype($transferDate)), __LINE__);
        }
        $this->TransferDate = $transferDate;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\Identifier|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\Identifier $driver
     * @return \StructType\Planning
     */
    public function setDriver(\StructType\Identifier $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\Planning
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Site value
     * @return \StructType\IdentifierSite|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\IdentifierSite $site
     * @return \StructType\Planning
     */
    public function setSite(\StructType\IdentifierSite $site = null)
    {
        $this->Site = $site;
        return $this;
    }
}
