<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceIdentifier_V3 StructType
 * @subpackage Structs
 */
class PlaceIdentifier_V3 extends AbstractStructBase
{
    /**
     * The TransicsPlaceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsPlaceID;
    /**
     * The SalesPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SalesPrice;
    /**
     * The PlaceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceID;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerResult_V2
     */
    public $Customer;
    /**
     * The Shipper
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShipperResult_V2
     */
    public $Shipper;
    /**
     * The AddressDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressDescription;
    /**
     * Constructor method for PlaceIdentifier_V3
     * @uses PlaceIdentifier_V3::setTransicsPlaceID()
     * @uses PlaceIdentifier_V3::setSalesPrice()
     * @uses PlaceIdentifier_V3::setPlaceID()
     * @uses PlaceIdentifier_V3::setCustomer()
     * @uses PlaceIdentifier_V3::setShipper()
     * @uses PlaceIdentifier_V3::setAddressDescription()
     * @param int $transicsPlaceID
     * @param float $salesPrice
     * @param string $placeID
     * @param \StructType\CustomerResult_V2 $customer
     * @param \StructType\ShipperResult_V2 $shipper
     * @param string $addressDescription
     */
    public function __construct($transicsPlaceID = null, $salesPrice = null, $placeID = null, \StructType\CustomerResult_V2 $customer = null, \StructType\ShipperResult_V2 $shipper = null, $addressDescription = null)
    {
        $this
            ->setTransicsPlaceID($transicsPlaceID)
            ->setSalesPrice($salesPrice)
            ->setPlaceID($placeID)
            ->setCustomer($customer)
            ->setShipper($shipper)
            ->setAddressDescription($addressDescription);
    }
    /**
     * Get TransicsPlaceID value
     * @return int
     */
    public function getTransicsPlaceID()
    {
        return $this->TransicsPlaceID;
    }
    /**
     * Set TransicsPlaceID value
     * @param int $transicsPlaceID
     * @return \StructType\PlaceIdentifier_V3
     */
    public function setTransicsPlaceID($transicsPlaceID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsPlaceID) && !(is_int($transicsPlaceID) || ctype_digit($transicsPlaceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transicsPlaceID, true), gettype($transicsPlaceID)), __LINE__);
        }
        $this->TransicsPlaceID = $transicsPlaceID;
        return $this;
    }
    /**
     * Get SalesPrice value
     * @return float
     */
    public function getSalesPrice()
    {
        return $this->SalesPrice;
    }
    /**
     * Set SalesPrice value
     * @param float $salesPrice
     * @return \StructType\PlaceIdentifier_V3
     */
    public function setSalesPrice($salesPrice = null)
    {
        // validation for constraint: float
        if (!is_null($salesPrice) && !(is_float($salesPrice) || is_numeric($salesPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($salesPrice, true), gettype($salesPrice)), __LINE__);
        }
        $this->SalesPrice = $salesPrice;
        return $this;
    }
    /**
     * Get PlaceID value
     * @return string|null
     */
    public function getPlaceID()
    {
        return $this->PlaceID;
    }
    /**
     * Set PlaceID value
     * @param string $placeID
     * @return \StructType\PlaceIdentifier_V3
     */
    public function setPlaceID($placeID = null)
    {
        // validation for constraint: string
        if (!is_null($placeID) && !is_string($placeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeID, true), gettype($placeID)), __LINE__);
        }
        $this->PlaceID = $placeID;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerResult_V2|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerResult_V2 $customer
     * @return \StructType\PlaceIdentifier_V3
     */
    public function setCustomer(\StructType\CustomerResult_V2 $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \StructType\ShipperResult_V2|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \StructType\ShipperResult_V2 $shipper
     * @return \StructType\PlaceIdentifier_V3
     */
    public function setShipper(\StructType\ShipperResult_V2 $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get AddressDescription value
     * @return string|null
     */
    public function getAddressDescription()
    {
        return $this->AddressDescription;
    }
    /**
     * Set AddressDescription value
     * @param string $addressDescription
     * @return \StructType\PlaceIdentifier_V3
     */
    public function setAddressDescription($addressDescription = null)
    {
        // validation for constraint: string
        if (!is_null($addressDescription) && !is_string($addressDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressDescription, true), gettype($addressDescription)), __LINE__);
        }
        $this->AddressDescription = $addressDescription;
        return $this;
    }
}
