<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonUpdate_V2 StructType
 * @subpackage Structs
 */
class PersonUpdate_V2 extends Person_V2
{
    /**
     * The Site
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierSite
     */
    public $Site;
    /**
     * The Responsible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $Responsible;
    /**
     * The DriverToUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $DriverToUpdate;
    /**
     * Constructor method for PersonUpdate_V2
     * @uses PersonUpdate_V2::setSite()
     * @uses PersonUpdate_V2::setResponsible()
     * @uses PersonUpdate_V2::setDriverToUpdate()
     * @param \StructType\IdentifierSite $site
     * @param \StructType\Identifier $responsible
     * @param \StructType\Identifier $driverToUpdate
     */
    public function __construct(\StructType\IdentifierSite $site = null, \StructType\Identifier $responsible = null, \StructType\Identifier $driverToUpdate = null)
    {
        $this
            ->setSite($site)
            ->setResponsible($responsible)
            ->setDriverToUpdate($driverToUpdate);
    }
    /**
     * Get Site value
     * @return \StructType\IdentifierSite|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\IdentifierSite $site
     * @return \StructType\PersonUpdate_V2
     */
    public function setSite(\StructType\IdentifierSite $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Responsible value
     * @return \StructType\Identifier|null
     */
    public function getResponsible()
    {
        return $this->Responsible;
    }
    /**
     * Set Responsible value
     * @param \StructType\Identifier $responsible
     * @return \StructType\PersonUpdate_V2
     */
    public function setResponsible(\StructType\Identifier $responsible = null)
    {
        $this->Responsible = $responsible;
        return $this;
    }
    /**
     * Get DriverToUpdate value
     * @return \StructType\Identifier|null
     */
    public function getDriverToUpdate()
    {
        return $this->DriverToUpdate;
    }
    /**
     * Set DriverToUpdate value
     * @param \StructType\Identifier $driverToUpdate
     * @return \StructType\PersonUpdate_V2
     */
    public function setDriverToUpdate(\StructType\Identifier $driverToUpdate = null)
    {
        $this->DriverToUpdate = $driverToUpdate;
        return $this;
    }
}
