<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonLanguages_V2 StructType
 * @subpackage Structs
 */
class PersonLanguages_V2 extends AbstractStructBase
{
    /**
     * The WorkingLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkingLanguage;
    /**
     * The ObcUILanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObcUILanguage;
    /**
     * The ObcInstructionSetLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObcInstructionSetLanguage;
    /**
     * Constructor method for PersonLanguages_V2
     * @uses PersonLanguages_V2::setWorkingLanguage()
     * @uses PersonLanguages_V2::setObcUILanguage()
     * @uses PersonLanguages_V2::setObcInstructionSetLanguage()
     * @param string $workingLanguage
     * @param string $obcUILanguage
     * @param string $obcInstructionSetLanguage
     */
    public function __construct($workingLanguage = null, $obcUILanguage = null, $obcInstructionSetLanguage = null)
    {
        $this
            ->setWorkingLanguage($workingLanguage)
            ->setObcUILanguage($obcUILanguage)
            ->setObcInstructionSetLanguage($obcInstructionSetLanguage);
    }
    /**
     * Get WorkingLanguage value
     * @return string|null
     */
    public function getWorkingLanguage()
    {
        return $this->WorkingLanguage;
    }
    /**
     * Set WorkingLanguage value
     * @param string $workingLanguage
     * @return \StructType\PersonLanguages_V2
     */
    public function setWorkingLanguage($workingLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($workingLanguage) && !is_string($workingLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workingLanguage, true), gettype($workingLanguage)), __LINE__);
        }
        $this->WorkingLanguage = $workingLanguage;
        return $this;
    }
    /**
     * Get ObcUILanguage value
     * @return string|null
     */
    public function getObcUILanguage()
    {
        return $this->ObcUILanguage;
    }
    /**
     * Set ObcUILanguage value
     * @param string $obcUILanguage
     * @return \StructType\PersonLanguages_V2
     */
    public function setObcUILanguage($obcUILanguage = null)
    {
        // validation for constraint: string
        if (!is_null($obcUILanguage) && !is_string($obcUILanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obcUILanguage, true), gettype($obcUILanguage)), __LINE__);
        }
        $this->ObcUILanguage = $obcUILanguage;
        return $this;
    }
    /**
     * Get ObcInstructionSetLanguage value
     * @return string|null
     */
    public function getObcInstructionSetLanguage()
    {
        return $this->ObcInstructionSetLanguage;
    }
    /**
     * Set ObcInstructionSetLanguage value
     * @param string $obcInstructionSetLanguage
     * @return \StructType\PersonLanguages_V2
     */
    public function setObcInstructionSetLanguage($obcInstructionSetLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($obcInstructionSetLanguage) && !is_string($obcInstructionSetLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obcInstructionSetLanguage, true), gettype($obcInstructionSetLanguage)), __LINE__);
        }
        $this->ObcInstructionSetLanguage = $obcInstructionSetLanguage;
        return $this;
    }
}
