<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonIdentification StructType
 * @subpackage Structs
 */
class PersonIdentification extends AbstractStructBase
{
    /**
     * The RegistrationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegistrationNumber;
    /**
     * The SocialExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SocialExternalId;
    /**
     * The HealthCareSecurityNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HealthCareSecurityNumber;
    /**
     * Constructor method for PersonIdentification
     * @uses PersonIdentification::setRegistrationNumber()
     * @uses PersonIdentification::setSocialExternalId()
     * @uses PersonIdentification::setHealthCareSecurityNumber()
     * @param string $registrationNumber
     * @param string $socialExternalId
     * @param string $healthCareSecurityNumber
     */
    public function __construct($registrationNumber = null, $socialExternalId = null, $healthCareSecurityNumber = null)
    {
        $this
            ->setRegistrationNumber($registrationNumber)
            ->setSocialExternalId($socialExternalId)
            ->setHealthCareSecurityNumber($healthCareSecurityNumber);
    }
    /**
     * Get RegistrationNumber value
     * @return string|null
     */
    public function getRegistrationNumber()
    {
        return $this->RegistrationNumber;
    }
    /**
     * Set RegistrationNumber value
     * @param string $registrationNumber
     * @return \StructType\PersonIdentification
     */
    public function setRegistrationNumber($registrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($registrationNumber) && !is_string($registrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationNumber, true), gettype($registrationNumber)), __LINE__);
        }
        $this->RegistrationNumber = $registrationNumber;
        return $this;
    }
    /**
     * Get SocialExternalId value
     * @return string|null
     */
    public function getSocialExternalId()
    {
        return $this->SocialExternalId;
    }
    /**
     * Set SocialExternalId value
     * @param string $socialExternalId
     * @return \StructType\PersonIdentification
     */
    public function setSocialExternalId($socialExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($socialExternalId) && !is_string($socialExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialExternalId, true), gettype($socialExternalId)), __LINE__);
        }
        $this->SocialExternalId = $socialExternalId;
        return $this;
    }
    /**
     * Get HealthCareSecurityNumber value
     * @return string|null
     */
    public function getHealthCareSecurityNumber()
    {
        return $this->HealthCareSecurityNumber;
    }
    /**
     * Set HealthCareSecurityNumber value
     * @param string $healthCareSecurityNumber
     * @return \StructType\PersonIdentification
     */
    public function setHealthCareSecurityNumber($healthCareSecurityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($healthCareSecurityNumber) && !is_string($healthCareSecurityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($healthCareSecurityNumber, true), gettype($healthCareSecurityNumber)), __LINE__);
        }
        $this->HealthCareSecurityNumber = $healthCareSecurityNumber;
        return $this;
    }
}
