<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonContactInfo_V2 StructType
 * @subpackage Structs
 */
class PersonContactInfo_V2 extends AbstractStructBase
{
    /**
     * The Mailbox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mailbox;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonAddress_V2
     */
    public $Address;
    /**
     * Constructor method for PersonContactInfo_V2
     * @uses PersonContactInfo_V2::setMailbox()
     * @uses PersonContactInfo_V2::setPhone()
     * @uses PersonContactInfo_V2::setAddress()
     * @param string $mailbox
     * @param string $phone
     * @param \StructType\PersonAddress_V2 $address
     */
    public function __construct($mailbox = null, $phone = null, \StructType\PersonAddress_V2 $address = null)
    {
        $this
            ->setMailbox($mailbox)
            ->setPhone($phone)
            ->setAddress($address);
    }
    /**
     * Get Mailbox value
     * @return string|null
     */
    public function getMailbox()
    {
        return $this->Mailbox;
    }
    /**
     * Set Mailbox value
     * @param string $mailbox
     * @return \StructType\PersonContactInfo_V2
     */
    public function setMailbox($mailbox = null)
    {
        // validation for constraint: string
        if (!is_null($mailbox) && !is_string($mailbox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailbox, true), gettype($mailbox)), __LINE__);
        }
        $this->Mailbox = $mailbox;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\PersonContactInfo_V2
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\PersonAddress_V2|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\PersonAddress_V2 $address
     * @return \StructType\PersonContactInfo_V2
     */
    public function setAddress(\StructType\PersonAddress_V2 $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
