<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POISelection StructType
 * @subpackage Structs
 */
class POISelection extends AbstractStructBase
{
    /**
     * The POIActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $POIActive;
    /**
     * The IncludeGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeGroups;
    /**
     * The IncludeContactPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeContactPerson;
    /**
     * The IncludeOpeningHours
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeOpeningHours;
    /**
     * The IncludeExtraInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeExtraInformation;
    /**
     * The PoiIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $PoiIDs;
    /**
     * The PoiNames
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $PoiNames;
    /**
     * The POIsNearPosition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionArea
     */
    public $POIsNearPosition;
    /**
     * Constructor method for POISelection
     * @uses POISelection::setPOIActive()
     * @uses POISelection::setIncludeGroups()
     * @uses POISelection::setIncludeContactPerson()
     * @uses POISelection::setIncludeOpeningHours()
     * @uses POISelection::setIncludeExtraInformation()
     * @uses POISelection::setPoiIDs()
     * @uses POISelection::setPoiNames()
     * @uses POISelection::setPOIsNearPosition()
     * @param bool $pOIActive
     * @param bool $includeGroups
     * @param bool $includeContactPerson
     * @param bool $includeOpeningHours
     * @param bool $includeExtraInformation
     * @param \ArrayType\ArrayOfInt $poiIDs
     * @param \ArrayType\ArrayOfString $poiNames
     * @param \StructType\PositionArea $pOIsNearPosition
     */
    public function __construct($pOIActive = null, $includeGroups = null, $includeContactPerson = null, $includeOpeningHours = null, $includeExtraInformation = null, \ArrayType\ArrayOfInt $poiIDs = null, \ArrayType\ArrayOfString $poiNames = null, \StructType\PositionArea $pOIsNearPosition = null)
    {
        $this
            ->setPOIActive($pOIActive)
            ->setIncludeGroups($includeGroups)
            ->setIncludeContactPerson($includeContactPerson)
            ->setIncludeOpeningHours($includeOpeningHours)
            ->setIncludeExtraInformation($includeExtraInformation)
            ->setPoiIDs($poiIDs)
            ->setPoiNames($poiNames)
            ->setPOIsNearPosition($pOIsNearPosition);
    }
    /**
     * Get POIActive value
     * @return bool
     */
    public function getPOIActive()
    {
        return $this->POIActive;
    }
    /**
     * Set POIActive value
     * @param bool $pOIActive
     * @return \StructType\POISelection
     */
    public function setPOIActive($pOIActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($pOIActive) && !is_bool($pOIActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pOIActive, true), gettype($pOIActive)), __LINE__);
        }
        $this->POIActive = $pOIActive;
        return $this;
    }
    /**
     * Get IncludeGroups value
     * @return bool
     */
    public function getIncludeGroups()
    {
        return $this->IncludeGroups;
    }
    /**
     * Set IncludeGroups value
     * @param bool $includeGroups
     * @return \StructType\POISelection
     */
    public function setIncludeGroups($includeGroups = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeGroups) && !is_bool($includeGroups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeGroups, true), gettype($includeGroups)), __LINE__);
        }
        $this->IncludeGroups = $includeGroups;
        return $this;
    }
    /**
     * Get IncludeContactPerson value
     * @return bool
     */
    public function getIncludeContactPerson()
    {
        return $this->IncludeContactPerson;
    }
    /**
     * Set IncludeContactPerson value
     * @param bool $includeContactPerson
     * @return \StructType\POISelection
     */
    public function setIncludeContactPerson($includeContactPerson = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeContactPerson) && !is_bool($includeContactPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeContactPerson, true), gettype($includeContactPerson)), __LINE__);
        }
        $this->IncludeContactPerson = $includeContactPerson;
        return $this;
    }
    /**
     * Get IncludeOpeningHours value
     * @return bool
     */
    public function getIncludeOpeningHours()
    {
        return $this->IncludeOpeningHours;
    }
    /**
     * Set IncludeOpeningHours value
     * @param bool $includeOpeningHours
     * @return \StructType\POISelection
     */
    public function setIncludeOpeningHours($includeOpeningHours = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeOpeningHours) && !is_bool($includeOpeningHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeOpeningHours, true), gettype($includeOpeningHours)), __LINE__);
        }
        $this->IncludeOpeningHours = $includeOpeningHours;
        return $this;
    }
    /**
     * Get IncludeExtraInformation value
     * @return bool
     */
    public function getIncludeExtraInformation()
    {
        return $this->IncludeExtraInformation;
    }
    /**
     * Set IncludeExtraInformation value
     * @param bool $includeExtraInformation
     * @return \StructType\POISelection
     */
    public function setIncludeExtraInformation($includeExtraInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeExtraInformation) && !is_bool($includeExtraInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeExtraInformation, true), gettype($includeExtraInformation)), __LINE__);
        }
        $this->IncludeExtraInformation = $includeExtraInformation;
        return $this;
    }
    /**
     * Get PoiIDs value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getPoiIDs()
    {
        return $this->PoiIDs;
    }
    /**
     * Set PoiIDs value
     * @param \ArrayType\ArrayOfInt $poiIDs
     * @return \StructType\POISelection
     */
    public function setPoiIDs(\ArrayType\ArrayOfInt $poiIDs = null)
    {
        $this->PoiIDs = $poiIDs;
        return $this;
    }
    /**
     * Get PoiNames value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getPoiNames()
    {
        return $this->PoiNames;
    }
    /**
     * Set PoiNames value
     * @param \ArrayType\ArrayOfString $poiNames
     * @return \StructType\POISelection
     */
    public function setPoiNames(\ArrayType\ArrayOfString $poiNames = null)
    {
        $this->PoiNames = $poiNames;
        return $this;
    }
    /**
     * Get POIsNearPosition value
     * @return \StructType\PositionArea|null
     */
    public function getPOIsNearPosition()
    {
        return $this->POIsNearPosition;
    }
    /**
     * Set POIsNearPosition value
     * @param \StructType\PositionArea $pOIsNearPosition
     * @return \StructType\POISelection
     */
    public function setPOIsNearPosition(\StructType\PositionArea $pOIsNearPosition = null)
    {
        $this->POIsNearPosition = $pOIsNearPosition;
        return $this;
    }
}
