<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NextStopCreationInfo StructType
 * @subpackage Structs
 */
class NextStopCreationInfo extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The CreatorSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreatorSource;
    /**
     * The Dispatcher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Dispatcher;
    /**
     * Constructor method for NextStopCreationInfo
     * @uses NextStopCreationInfo::setDate()
     * @uses NextStopCreationInfo::setCreatorSource()
     * @uses NextStopCreationInfo::setDispatcher()
     * @param string $date
     * @param string $creatorSource
     * @param \StructType\IdentifierPerson $dispatcher
     */
    public function __construct($date = null, $creatorSource = null, \StructType\IdentifierPerson $dispatcher = null)
    {
        $this
            ->setDate($date)
            ->setCreatorSource($creatorSource)
            ->setDispatcher($dispatcher);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\NextStopCreationInfo
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get CreatorSource value
     * @return string
     */
    public function getCreatorSource()
    {
        return $this->CreatorSource;
    }
    /**
     * Set CreatorSource value
     * @uses \EnumType\CreationSource::valueIsValid()
     * @uses \EnumType\CreationSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creatorSource
     * @return \StructType\NextStopCreationInfo
     */
    public function setCreatorSource($creatorSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreationSource::valueIsValid($creatorSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CreationSource', is_array($creatorSource) ? implode(', ', $creatorSource) : var_export($creatorSource, true), implode(', ', \EnumType\CreationSource::getValidValues())), __LINE__);
        }
        $this->CreatorSource = $creatorSource;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param \StructType\IdentifierPerson $dispatcher
     * @return \StructType\NextStopCreationInfo
     */
    public function setDispatcher(\StructType\IdentifierPerson $dispatcher = null)
    {
        $this->Dispatcher = $dispatcher;
        return $this;
    }
}
