<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManagementOfActivityPeriod StructType
 * @subpackage Structs
 */
class ManagementOfActivityPeriod extends AbstractStructBase
{
    /**
     * The ActivityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityPeriod;
    /**
     * The ActivityRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityRange
     */
    public $ActivityRange;
    /**
     * Constructor method for ManagementOfActivityPeriod
     * @uses ManagementOfActivityPeriod::setActivityPeriod()
     * @uses ManagementOfActivityPeriod::setActivityRange()
     * @param string $activityPeriod
     * @param \StructType\ActivityRange $activityRange
     */
    public function __construct($activityPeriod = null, \StructType\ActivityRange $activityRange = null)
    {
        $this
            ->setActivityPeriod($activityPeriod)
            ->setActivityRange($activityRange);
    }
    /**
     * Get ActivityPeriod value
     * @return string|null
     */
    public function getActivityPeriod()
    {
        return $this->ActivityPeriod;
    }
    /**
     * Set ActivityPeriod value
     * @param string $activityPeriod
     * @return \StructType\ManagementOfActivityPeriod
     */
    public function setActivityPeriod($activityPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($activityPeriod) && !is_string($activityPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityPeriod, true), gettype($activityPeriod)), __LINE__);
        }
        $this->ActivityPeriod = $activityPeriod;
        return $this;
    }
    /**
     * Get ActivityRange value
     * @return \StructType\ActivityRange|null
     */
    public function getActivityRange()
    {
        return $this->ActivityRange;
    }
    /**
     * Set ActivityRange value
     * @param \StructType\ActivityRange $activityRange
     * @return \StructType\ManagementOfActivityPeriod
     */
    public function setActivityRange(\StructType\ActivityRange $activityRange = null)
    {
        $this->ActivityRange = $activityRange;
        return $this;
    }
}
