<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MagellanTracerPositionInfo StructType
 * @subpackage Structs
 */
class MagellanTracerPositionInfo extends AbstractStructBase
{
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Direction;
    /**
     * The Speed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Speed;
    /**
     * The PositionDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PositionDateTime;
    /**
     * The LastMovement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastMovement;
    /**
     * The PositionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PositionID;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The BatteryStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BatteryStatus
     */
    public $BatteryStatus;
    /**
     * The PositionSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PositionSource;
    /**
     * Constructor method for MagellanTracerPositionInfo
     * @uses MagellanTracerPositionInfo::setDirection()
     * @uses MagellanTracerPositionInfo::setSpeed()
     * @uses MagellanTracerPositionInfo::setPositionDateTime()
     * @uses MagellanTracerPositionInfo::setLastMovement()
     * @uses MagellanTracerPositionInfo::setPositionID()
     * @uses MagellanTracerPositionInfo::setPosition()
     * @uses MagellanTracerPositionInfo::setBatteryStatus()
     * @uses MagellanTracerPositionInfo::setPositionSource()
     * @param int $direction
     * @param int $speed
     * @param string $positionDateTime
     * @param string $lastMovement
     * @param int $positionID
     * @param \StructType\Position $position
     * @param \StructType\BatteryStatus $batteryStatus
     * @param string $positionSource
     */
    public function __construct($direction = null, $speed = null, $positionDateTime = null, $lastMovement = null, $positionID = null, \StructType\Position $position = null, \StructType\BatteryStatus $batteryStatus = null, $positionSource = null)
    {
        $this
            ->setDirection($direction)
            ->setSpeed($speed)
            ->setPositionDateTime($positionDateTime)
            ->setLastMovement($lastMovement)
            ->setPositionID($positionID)
            ->setPosition($position)
            ->setBatteryStatus($batteryStatus)
            ->setPositionSource($positionSource);
    }
    /**
     * Get Direction value
     * @return int
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param int $direction
     * @return \StructType\MagellanTracerPositionInfo
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: int
        if (!is_null($direction) && !(is_int($direction) || ctype_digit($direction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($direction, true), gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Speed value
     * @return int
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param int $speed
     * @return \StructType\MagellanTracerPositionInfo
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !(is_int($speed) || ctype_digit($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get PositionDateTime value
     * @return string
     */
    public function getPositionDateTime()
    {
        return $this->PositionDateTime;
    }
    /**
     * Set PositionDateTime value
     * @param string $positionDateTime
     * @return \StructType\MagellanTracerPositionInfo
     */
    public function setPositionDateTime($positionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($positionDateTime) && !is_string($positionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positionDateTime, true), gettype($positionDateTime)), __LINE__);
        }
        $this->PositionDateTime = $positionDateTime;
        return $this;
    }
    /**
     * Get LastMovement value
     * @return string
     */
    public function getLastMovement()
    {
        return $this->LastMovement;
    }
    /**
     * Set LastMovement value
     * @param string $lastMovement
     * @return \StructType\MagellanTracerPositionInfo
     */
    public function setLastMovement($lastMovement = null)
    {
        // validation for constraint: string
        if (!is_null($lastMovement) && !is_string($lastMovement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastMovement, true), gettype($lastMovement)), __LINE__);
        }
        $this->LastMovement = $lastMovement;
        return $this;
    }
    /**
     * Get PositionID value
     * @return int
     */
    public function getPositionID()
    {
        return $this->PositionID;
    }
    /**
     * Set PositionID value
     * @param int $positionID
     * @return \StructType\MagellanTracerPositionInfo
     */
    public function setPositionID($positionID = null)
    {
        // validation for constraint: int
        if (!is_null($positionID) && !(is_int($positionID) || ctype_digit($positionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionID, true), gettype($positionID)), __LINE__);
        }
        $this->PositionID = $positionID;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\MagellanTracerPositionInfo
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get BatteryStatus value
     * @return \StructType\BatteryStatus|null
     */
    public function getBatteryStatus()
    {
        return $this->BatteryStatus;
    }
    /**
     * Set BatteryStatus value
     * @param \StructType\BatteryStatus $batteryStatus
     * @return \StructType\MagellanTracerPositionInfo
     */
    public function setBatteryStatus(\StructType\BatteryStatus $batteryStatus = null)
    {
        $this->BatteryStatus = $batteryStatus;
        return $this;
    }
    /**
     * Get PositionSource value
     * @return string|null
     */
    public function getPositionSource()
    {
        return $this->PositionSource;
    }
    /**
     * Set PositionSource value
     * @param string $positionSource
     * @return \StructType\MagellanTracerPositionInfo
     */
    public function setPositionSource($positionSource = null)
    {
        // validation for constraint: string
        if (!is_null($positionSource) && !is_string($positionSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positionSource, true), gettype($positionSource)), __LINE__);
        }
        $this->PositionSource = $positionSource;
        return $this;
    }
}
