<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobInterfaceResult_v2 StructType
 * @subpackage Structs
 */
class JobInterfaceResult_v2 extends Job
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Export
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Export;
    /**
     * The CreatedbyDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CreatedbyDriver;
    /**
     * The ExternalSynchStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExternalSynchStatus;
    /**
     * The CancelStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CancelStatus;
    /**
     * The ModificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ModificationDate;
    /**
     * The ModificationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ModificationNumber;
    /**
     * The ModificationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ModificationID;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * The Transfer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Transfer
     */
    public $Transfer;
    /**
     * The Anomalies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnomaly
     */
    public $Anomalies;
    /**
     * The PalletInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo
     */
    public $PalletInfos;
    /**
     * The ExtraInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExtraInfo
     */
    public $ExtraInfos;
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductInterfaceResult_v2
     */
    public $Products;
    /**
     * Constructor method for JobInterfaceResult_v2
     * @uses JobInterfaceResult_v2::setStatus()
     * @uses JobInterfaceResult_v2::setExport()
     * @uses JobInterfaceResult_v2::setCreatedbyDriver()
     * @uses JobInterfaceResult_v2::setExternalSynchStatus()
     * @uses JobInterfaceResult_v2::setCancelStatus()
     * @uses JobInterfaceResult_v2::setModificationDate()
     * @uses JobInterfaceResult_v2::setModificationNumber()
     * @uses JobInterfaceResult_v2::setModificationID()
     * @uses JobInterfaceResult_v2::setAuthor()
     * @uses JobInterfaceResult_v2::setTransfer()
     * @uses JobInterfaceResult_v2::setAnomalies()
     * @uses JobInterfaceResult_v2::setPalletInfos()
     * @uses JobInterfaceResult_v2::setExtraInfos()
     * @uses JobInterfaceResult_v2::setProducts()
     * @param string $status
     * @param int $export
     * @param bool $createdbyDriver
     * @param string $externalSynchStatus
     * @param string $cancelStatus
     * @param string $modificationDate
     * @param int $modificationNumber
     * @param int $modificationID
     * @param string $author
     * @param \StructType\Transfer $transfer
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @param \ArrayType\ArrayOfExtraInfo $palletInfos
     * @param \ArrayType\ArrayOfExtraInfo $extraInfos
     * @param \ArrayType\ArrayOfProductInterfaceResult_v2 $products
     */
    public function __construct($status = null, $export = null, $createdbyDriver = null, $externalSynchStatus = null, $cancelStatus = null, $modificationDate = null, $modificationNumber = null, $modificationID = null, $author = null, \StructType\Transfer $transfer = null, \ArrayType\ArrayOfAnomaly $anomalies = null, \ArrayType\ArrayOfExtraInfo $palletInfos = null, \ArrayType\ArrayOfExtraInfo $extraInfos = null, \ArrayType\ArrayOfProductInterfaceResult_v2 $products = null)
    {
        $this
            ->setStatus($status)
            ->setExport($export)
            ->setCreatedbyDriver($createdbyDriver)
            ->setExternalSynchStatus($externalSynchStatus)
            ->setCancelStatus($cancelStatus)
            ->setModificationDate($modificationDate)
            ->setModificationNumber($modificationNumber)
            ->setModificationID($modificationID)
            ->setAuthor($author)
            ->setTransfer($transfer)
            ->setAnomalies($anomalies)
            ->setPalletInfos($palletInfos)
            ->setExtraInfos($extraInfos)
            ->setProducts($products);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\EnumTransferStatus::valueIsValid()
     * @uses \EnumType\EnumTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTransferStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTransferStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\EnumTransferStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Export value
     * @return int
     */
    public function getExport()
    {
        return $this->Export;
    }
    /**
     * Set Export value
     * @param int $export
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setExport($export = null)
    {
        // validation for constraint: int
        if (!is_null($export) && !(is_int($export) || ctype_digit($export))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($export, true), gettype($export)), __LINE__);
        }
        $this->Export = $export;
        return $this;
    }
    /**
     * Get CreatedbyDriver value
     * @return bool
     */
    public function getCreatedbyDriver()
    {
        return $this->CreatedbyDriver;
    }
    /**
     * Set CreatedbyDriver value
     * @param bool $createdbyDriver
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setCreatedbyDriver($createdbyDriver = null)
    {
        // validation for constraint: boolean
        if (!is_null($createdbyDriver) && !is_bool($createdbyDriver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createdbyDriver, true), gettype($createdbyDriver)), __LINE__);
        }
        $this->CreatedbyDriver = $createdbyDriver;
        return $this;
    }
    /**
     * Get ExternalSynchStatus value
     * @return string
     */
    public function getExternalSynchStatus()
    {
        return $this->ExternalSynchStatus;
    }
    /**
     * Set ExternalSynchStatus value
     * @uses \EnumType\EnumSynchronisationStatus::valueIsValid()
     * @uses \EnumType\EnumSynchronisationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $externalSynchStatus
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setExternalSynchStatus($externalSynchStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumSynchronisationStatus::valueIsValid($externalSynchStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumSynchronisationStatus', is_array($externalSynchStatus) ? implode(', ', $externalSynchStatus) : var_export($externalSynchStatus, true), implode(', ', \EnumType\EnumSynchronisationStatus::getValidValues())), __LINE__);
        }
        $this->ExternalSynchStatus = $externalSynchStatus;
        return $this;
    }
    /**
     * Get CancelStatus value
     * @return string
     */
    public function getCancelStatus()
    {
        return $this->CancelStatus;
    }
    /**
     * Set CancelStatus value
     * @uses \EnumType\EnumCancelStatus::valueIsValid()
     * @uses \EnumType\EnumCancelStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelStatus
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setCancelStatus($cancelStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCancelStatus::valueIsValid($cancelStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumCancelStatus', is_array($cancelStatus) ? implode(', ', $cancelStatus) : var_export($cancelStatus, true), implode(', ', \EnumType\EnumCancelStatus::getValidValues())), __LINE__);
        }
        $this->CancelStatus = $cancelStatus;
        return $this;
    }
    /**
     * Get ModificationDate value
     * @return string
     */
    public function getModificationDate()
    {
        return $this->ModificationDate;
    }
    /**
     * Set ModificationDate value
     * @param string $modificationDate
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->ModificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get ModificationNumber value
     * @return int
     */
    public function getModificationNumber()
    {
        return $this->ModificationNumber;
    }
    /**
     * Set ModificationNumber value
     * @param int $modificationNumber
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setModificationNumber($modificationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($modificationNumber) && !(is_int($modificationNumber) || ctype_digit($modificationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modificationNumber, true), gettype($modificationNumber)), __LINE__);
        }
        $this->ModificationNumber = $modificationNumber;
        return $this;
    }
    /**
     * Get ModificationID value
     * @return int
     */
    public function getModificationID()
    {
        return $this->ModificationID;
    }
    /**
     * Set ModificationID value
     * @param int $modificationID
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setModificationID($modificationID = null)
    {
        // validation for constraint: int
        if (!is_null($modificationID) && !(is_int($modificationID) || ctype_digit($modificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modificationID, true), gettype($modificationID)), __LINE__);
        }
        $this->ModificationID = $modificationID;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
    /**
     * Get Transfer value
     * @return \StructType\Transfer|null
     */
    public function getTransfer()
    {
        return $this->Transfer;
    }
    /**
     * Set Transfer value
     * @param \StructType\Transfer $transfer
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setTransfer(\StructType\Transfer $transfer = null)
    {
        $this->Transfer = $transfer;
        return $this;
    }
    /**
     * Get Anomalies value
     * @return \ArrayType\ArrayOfAnomaly|null
     */
    public function getAnomalies()
    {
        return $this->Anomalies;
    }
    /**
     * Set Anomalies value
     * @param \ArrayType\ArrayOfAnomaly $anomalies
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setAnomalies(\ArrayType\ArrayOfAnomaly $anomalies = null)
    {
        $this->Anomalies = $anomalies;
        return $this;
    }
    /**
     * Get PalletInfos value
     * @return \ArrayType\ArrayOfExtraInfo|null
     */
    public function getPalletInfos()
    {
        return $this->PalletInfos;
    }
    /**
     * Set PalletInfos value
     * @param \ArrayType\ArrayOfExtraInfo $palletInfos
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setPalletInfos(\ArrayType\ArrayOfExtraInfo $palletInfos = null)
    {
        $this->PalletInfos = $palletInfos;
        return $this;
    }
    /**
     * Get ExtraInfos value
     * @return \ArrayType\ArrayOfExtraInfo|null
     */
    public function getExtraInfos()
    {
        return $this->ExtraInfos;
    }
    /**
     * Set ExtraInfos value
     * @param \ArrayType\ArrayOfExtraInfo $extraInfos
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setExtraInfos(\ArrayType\ArrayOfExtraInfo $extraInfos = null)
    {
        $this->ExtraInfos = $extraInfos;
        return $this;
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProductInterfaceResult_v2|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProductInterfaceResult_v2 $products
     * @return \StructType\JobInterfaceResult_v2
     */
    public function setProducts(\ArrayType\ArrayOfProductInterfaceResult_v2 $products = null)
    {
        $this->Products = $products;
        return $this;
    }
}
