<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobInsert StructType
 * @subpackage Structs
 */
class JobInsert extends Job
{
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductInsert
     */
    public $Products;
    /**
     * The PlanningConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningConfig
     */
    public $PlanningConfig;
    /**
     * Constructor method for JobInsert
     * @uses JobInsert::setProducts()
     * @uses JobInsert::setPlanningConfig()
     * @param \ArrayType\ArrayOfProductInsert $products
     * @param \StructType\PlanningConfig $planningConfig
     */
    public function __construct(\ArrayType\ArrayOfProductInsert $products = null, \StructType\PlanningConfig $planningConfig = null)
    {
        $this
            ->setProducts($products)
            ->setPlanningConfig($planningConfig);
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProductInsert|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProductInsert $products
     * @return \StructType\JobInsert
     */
    public function setProducts(\ArrayType\ArrayOfProductInsert $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get PlanningConfig value
     * @return \StructType\PlanningConfig|null
     */
    public function getPlanningConfig()
    {
        return $this->PlanningConfig;
    }
    /**
     * Set PlanningConfig value
     * @param \StructType\PlanningConfig $planningConfig
     * @return \StructType\JobInsert
     */
    public function setPlanningConfig(\StructType\PlanningConfig $planningConfig = null)
    {
        $this->PlanningConfig = $planningConfig;
        return $this;
    }
}
