<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job StructType
 * @subpackage Structs
 */
abstract class Job extends AbstractStructBase
{
    /**
     * The OrderSeq
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderSeq;
    /**
     * The CustomNr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomNr;
    /**
     * The JobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobId;
    /**
     * The DriverDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDisplay;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Job
     * @uses Job::setOrderSeq()
     * @uses Job::setCustomNr()
     * @uses Job::setJobId()
     * @uses Job::setDriverDisplay()
     * @uses Job::setComment()
     * @param int $orderSeq
     * @param int $customNr
     * @param string $jobId
     * @param string $driverDisplay
     * @param string $comment
     */
    public function __construct($orderSeq = null, $customNr = null, $jobId = null, $driverDisplay = null, $comment = null)
    {
        $this
            ->setOrderSeq($orderSeq)
            ->setCustomNr($customNr)
            ->setJobId($jobId)
            ->setDriverDisplay($driverDisplay)
            ->setComment($comment);
    }
    /**
     * Get OrderSeq value
     * @return int
     */
    public function getOrderSeq()
    {
        return $this->OrderSeq;
    }
    /**
     * Set OrderSeq value
     * @param int $orderSeq
     * @return \StructType\Job
     */
    public function setOrderSeq($orderSeq = null)
    {
        // validation for constraint: int
        if (!is_null($orderSeq) && !(is_int($orderSeq) || ctype_digit($orderSeq))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderSeq, true), gettype($orderSeq)), __LINE__);
        }
        $this->OrderSeq = $orderSeq;
        return $this;
    }
    /**
     * Get CustomNr value
     * @return int
     */
    public function getCustomNr()
    {
        return $this->CustomNr;
    }
    /**
     * Set CustomNr value
     * @param int $customNr
     * @return \StructType\Job
     */
    public function setCustomNr($customNr = null)
    {
        // validation for constraint: int
        if (!is_null($customNr) && !(is_int($customNr) || ctype_digit($customNr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customNr, true), gettype($customNr)), __LINE__);
        }
        $this->CustomNr = $customNr;
        return $this;
    }
    /**
     * Get JobId value
     * @return string|null
     */
    public function getJobId()
    {
        return $this->JobId;
    }
    /**
     * Set JobId value
     * @param string $jobId
     * @return \StructType\Job
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: string
        if (!is_null($jobId) && !is_string($jobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->JobId = $jobId;
        return $this;
    }
    /**
     * Get DriverDisplay value
     * @return string|null
     */
    public function getDriverDisplay()
    {
        return $this->DriverDisplay;
    }
    /**
     * Set DriverDisplay value
     * @param string $driverDisplay
     * @return \StructType\Job
     */
    public function setDriverDisplay($driverDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($driverDisplay) && !is_string($driverDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverDisplay, true), gettype($driverDisplay)), __LINE__);
        }
        $this->DriverDisplay = $driverDisplay;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Job
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
