<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceTachoCard_V2 StructType
 * @subpackage Structs
 */
class InterfaceTachoCard_V2 extends AbstractStructBase
{
    /**
     * The TachoLoginEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TachoLoginEnabled;
    /**
     * The StartOfValidity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartOfValidity;
    /**
     * The EndOfValidity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndOfValidity;
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardId;
    /**
     * The CountryCodeOfIssue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCodeOfIssue;
    /**
     * The RenewalIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RenewalIndex;
    /**
     * The ReplacementIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplacementIndex;
    /**
     * Constructor method for InterfaceTachoCard_V2
     * @uses InterfaceTachoCard_V2::setTachoLoginEnabled()
     * @uses InterfaceTachoCard_V2::setStartOfValidity()
     * @uses InterfaceTachoCard_V2::setEndOfValidity()
     * @uses InterfaceTachoCard_V2::setCardId()
     * @uses InterfaceTachoCard_V2::setCountryCodeOfIssue()
     * @uses InterfaceTachoCard_V2::setRenewalIndex()
     * @uses InterfaceTachoCard_V2::setReplacementIndex()
     * @param bool $tachoLoginEnabled
     * @param string $startOfValidity
     * @param string $endOfValidity
     * @param string $cardId
     * @param string $countryCodeOfIssue
     * @param string $renewalIndex
     * @param string $replacementIndex
     */
    public function __construct($tachoLoginEnabled = null, $startOfValidity = null, $endOfValidity = null, $cardId = null, $countryCodeOfIssue = null, $renewalIndex = null, $replacementIndex = null)
    {
        $this
            ->setTachoLoginEnabled($tachoLoginEnabled)
            ->setStartOfValidity($startOfValidity)
            ->setEndOfValidity($endOfValidity)
            ->setCardId($cardId)
            ->setCountryCodeOfIssue($countryCodeOfIssue)
            ->setRenewalIndex($renewalIndex)
            ->setReplacementIndex($replacementIndex);
    }
    /**
     * Get TachoLoginEnabled value
     * @return bool
     */
    public function getTachoLoginEnabled()
    {
        return $this->TachoLoginEnabled;
    }
    /**
     * Set TachoLoginEnabled value
     * @param bool $tachoLoginEnabled
     * @return \StructType\InterfaceTachoCard_V2
     */
    public function setTachoLoginEnabled($tachoLoginEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($tachoLoginEnabled) && !is_bool($tachoLoginEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tachoLoginEnabled, true), gettype($tachoLoginEnabled)), __LINE__);
        }
        $this->TachoLoginEnabled = $tachoLoginEnabled;
        return $this;
    }
    /**
     * Get StartOfValidity value
     * @return string
     */
    public function getStartOfValidity()
    {
        return $this->StartOfValidity;
    }
    /**
     * Set StartOfValidity value
     * @param string $startOfValidity
     * @return \StructType\InterfaceTachoCard_V2
     */
    public function setStartOfValidity($startOfValidity = null)
    {
        // validation for constraint: string
        if (!is_null($startOfValidity) && !is_string($startOfValidity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startOfValidity, true), gettype($startOfValidity)), __LINE__);
        }
        $this->StartOfValidity = $startOfValidity;
        return $this;
    }
    /**
     * Get EndOfValidity value
     * @return string
     */
    public function getEndOfValidity()
    {
        return $this->EndOfValidity;
    }
    /**
     * Set EndOfValidity value
     * @param string $endOfValidity
     * @return \StructType\InterfaceTachoCard_V2
     */
    public function setEndOfValidity($endOfValidity = null)
    {
        // validation for constraint: string
        if (!is_null($endOfValidity) && !is_string($endOfValidity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endOfValidity, true), gettype($endOfValidity)), __LINE__);
        }
        $this->EndOfValidity = $endOfValidity;
        return $this;
    }
    /**
     * Get CardId value
     * @return string|null
     */
    public function getCardId()
    {
        return $this->CardId;
    }
    /**
     * Set CardId value
     * @param string $cardId
     * @return \StructType\InterfaceTachoCard_V2
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        $this->CardId = $cardId;
        return $this;
    }
    /**
     * Get CountryCodeOfIssue value
     * @return string|null
     */
    public function getCountryCodeOfIssue()
    {
        return $this->CountryCodeOfIssue;
    }
    /**
     * Set CountryCodeOfIssue value
     * @param string $countryCodeOfIssue
     * @return \StructType\InterfaceTachoCard_V2
     */
    public function setCountryCodeOfIssue($countryCodeOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($countryCodeOfIssue) && !is_string($countryCodeOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCodeOfIssue, true), gettype($countryCodeOfIssue)), __LINE__);
        }
        $this->CountryCodeOfIssue = $countryCodeOfIssue;
        return $this;
    }
    /**
     * Get RenewalIndex value
     * @return string|null
     */
    public function getRenewalIndex()
    {
        return $this->RenewalIndex;
    }
    /**
     * Set RenewalIndex value
     * @param string $renewalIndex
     * @return \StructType\InterfaceTachoCard_V2
     */
    public function setRenewalIndex($renewalIndex = null)
    {
        // validation for constraint: string
        if (!is_null($renewalIndex) && !is_string($renewalIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewalIndex, true), gettype($renewalIndex)), __LINE__);
        }
        $this->RenewalIndex = $renewalIndex;
        return $this;
    }
    /**
     * Get ReplacementIndex value
     * @return string|null
     */
    public function getReplacementIndex()
    {
        return $this->ReplacementIndex;
    }
    /**
     * Set ReplacementIndex value
     * @param string $replacementIndex
     * @return \StructType\InterfaceTachoCard_V2
     */
    public function setReplacementIndex($replacementIndex = null)
    {
        // validation for constraint: string
        if (!is_null($replacementIndex) && !is_string($replacementIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replacementIndex, true), gettype($replacementIndex)), __LINE__);
        }
        $this->ReplacementIndex = $replacementIndex;
        return $this;
    }
}
