<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceTachoCardInfo_V2 StructType
 * @subpackage Structs
 */
class InterfaceTachoCardInfo_V2 extends AbstractStructBase
{
    /**
     * The TachoLoginEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TachoLoginEnabled;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExpirationDate;
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardId;
    /**
     * The CountryOfIssue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $CountryOfIssue;
    /**
     * Constructor method for InterfaceTachoCardInfo_V2
     * @uses InterfaceTachoCardInfo_V2::setTachoLoginEnabled()
     * @uses InterfaceTachoCardInfo_V2::setExpirationDate()
     * @uses InterfaceTachoCardInfo_V2::setCardId()
     * @uses InterfaceTachoCardInfo_V2::setCountryOfIssue()
     * @param bool $tachoLoginEnabled
     * @param string $expirationDate
     * @param string $cardId
     * @param \StructType\Country $countryOfIssue
     */
    public function __construct($tachoLoginEnabled = null, $expirationDate = null, $cardId = null, \StructType\Country $countryOfIssue = null)
    {
        $this
            ->setTachoLoginEnabled($tachoLoginEnabled)
            ->setExpirationDate($expirationDate)
            ->setCardId($cardId)
            ->setCountryOfIssue($countryOfIssue);
    }
    /**
     * Get TachoLoginEnabled value
     * @return bool
     */
    public function getTachoLoginEnabled()
    {
        return $this->TachoLoginEnabled;
    }
    /**
     * Set TachoLoginEnabled value
     * @param bool $tachoLoginEnabled
     * @return \StructType\InterfaceTachoCardInfo_V2
     */
    public function setTachoLoginEnabled($tachoLoginEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($tachoLoginEnabled) && !is_bool($tachoLoginEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tachoLoginEnabled, true), gettype($tachoLoginEnabled)), __LINE__);
        }
        $this->TachoLoginEnabled = $tachoLoginEnabled;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\InterfaceTachoCardInfo_V2
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get CardId value
     * @return string|null
     */
    public function getCardId()
    {
        return $this->CardId;
    }
    /**
     * Set CardId value
     * @param string $cardId
     * @return \StructType\InterfaceTachoCardInfo_V2
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        $this->CardId = $cardId;
        return $this;
    }
    /**
     * Get CountryOfIssue value
     * @return \StructType\Country|null
     */
    public function getCountryOfIssue()
    {
        return $this->CountryOfIssue;
    }
    /**
     * Set CountryOfIssue value
     * @param \StructType\Country $countryOfIssue
     * @return \StructType\InterfaceTachoCardInfo_V2
     */
    public function setCountryOfIssue(\StructType\Country $countryOfIssue = null)
    {
        $this->CountryOfIssue = $countryOfIssue;
        return $this;
    }
}
