<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfacePersonUpdate_V4 StructType
 * @subpackage Structs
 */
class InterfacePersonUpdate_V4 extends Person_V6
{
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Title;
    /**
     * The RemoveLatestManagementOfActivityInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RemoveLatestManagementOfActivityInfo;
    /**
     * The TachoStrategy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TachoStrategySelection
     */
    public $TachoStrategy;
    /**
     * The DriverToUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Identifier
     */
    public $DriverToUpdate;
    /**
     * The MyTransicsLink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MyTransicsUpdateInfo
     */
    public $MyTransicsLink;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfacePersonContactInfo_V3
     */
    public $ContactInfo;
    /**
     * The SocialInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonSocialInfo_V2
     */
    public $SocialInfo;
    /**
     * Constructor method for InterfacePersonUpdate_V4
     * @uses InterfacePersonUpdate_V4::setTitle()
     * @uses InterfacePersonUpdate_V4::setRemoveLatestManagementOfActivityInfo()
     * @uses InterfacePersonUpdate_V4::setTachoStrategy()
     * @uses InterfacePersonUpdate_V4::setDriverToUpdate()
     * @uses InterfacePersonUpdate_V4::setMyTransicsLink()
     * @uses InterfacePersonUpdate_V4::setLanguage()
     * @uses InterfacePersonUpdate_V4::setContactInfo()
     * @uses InterfacePersonUpdate_V4::setSocialInfo()
     * @param string $title
     * @param bool $removeLatestManagementOfActivityInfo
     * @param \StructType\TachoStrategySelection $tachoStrategy
     * @param \StructType\Identifier $driverToUpdate
     * @param \StructType\MyTransicsUpdateInfo $myTransicsLink
     * @param string $language
     * @param \StructType\InterfacePersonContactInfo_V3 $contactInfo
     * @param \StructType\PersonSocialInfo_V2 $socialInfo
     */
    public function __construct($title = null, $removeLatestManagementOfActivityInfo = null, \StructType\TachoStrategySelection $tachoStrategy = null, \StructType\Identifier $driverToUpdate = null, \StructType\MyTransicsUpdateInfo $myTransicsLink = null, $language = null, \StructType\InterfacePersonContactInfo_V3 $contactInfo = null, \StructType\PersonSocialInfo_V2 $socialInfo = null)
    {
        $this
            ->setTitle($title)
            ->setRemoveLatestManagementOfActivityInfo($removeLatestManagementOfActivityInfo)
            ->setTachoStrategy($tachoStrategy)
            ->setDriverToUpdate($driverToUpdate)
            ->setMyTransicsLink($myTransicsLink)
            ->setLanguage($language)
            ->setContactInfo($contactInfo)
            ->setSocialInfo($socialInfo);
    }
    /**
     * Get Title value
     * @return string
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @uses \EnumType\EnumTitle::valueIsValid()
     * @uses \EnumType\EnumTitle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $title
     * @return \StructType\InterfacePersonUpdate_V4
     */
    public function setTitle($title = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTitle::valueIsValid($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTitle', is_array($title) ? implode(', ', $title) : var_export($title, true), implode(', ', \EnumType\EnumTitle::getValidValues())), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get RemoveLatestManagementOfActivityInfo value
     * @return bool
     */
    public function getRemoveLatestManagementOfActivityInfo()
    {
        return $this->RemoveLatestManagementOfActivityInfo;
    }
    /**
     * Set RemoveLatestManagementOfActivityInfo value
     * @param bool $removeLatestManagementOfActivityInfo
     * @return \StructType\InterfacePersonUpdate_V4
     */
    public function setRemoveLatestManagementOfActivityInfo($removeLatestManagementOfActivityInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($removeLatestManagementOfActivityInfo) && !is_bool($removeLatestManagementOfActivityInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removeLatestManagementOfActivityInfo, true), gettype($removeLatestManagementOfActivityInfo)), __LINE__);
        }
        $this->RemoveLatestManagementOfActivityInfo = $removeLatestManagementOfActivityInfo;
        return $this;
    }
    /**
     * Get TachoStrategy value
     * @return \StructType\TachoStrategySelection|null
     */
    public function getTachoStrategy()
    {
        return $this->TachoStrategy;
    }
    /**
     * Set TachoStrategy value
     * @param \StructType\TachoStrategySelection $tachoStrategy
     * @return \StructType\InterfacePersonUpdate_V4
     */
    public function setTachoStrategy(\StructType\TachoStrategySelection $tachoStrategy = null)
    {
        $this->TachoStrategy = $tachoStrategy;
        return $this;
    }
    /**
     * Get DriverToUpdate value
     * @return \StructType\Identifier|null
     */
    public function getDriverToUpdate()
    {
        return $this->DriverToUpdate;
    }
    /**
     * Set DriverToUpdate value
     * @param \StructType\Identifier $driverToUpdate
     * @return \StructType\InterfacePersonUpdate_V4
     */
    public function setDriverToUpdate(\StructType\Identifier $driverToUpdate = null)
    {
        $this->DriverToUpdate = $driverToUpdate;
        return $this;
    }
    /**
     * Get MyTransicsLink value
     * @return \StructType\MyTransicsUpdateInfo|null
     */
    public function getMyTransicsLink()
    {
        return $this->MyTransicsLink;
    }
    /**
     * Set MyTransicsLink value
     * @param \StructType\MyTransicsUpdateInfo $myTransicsLink
     * @return \StructType\InterfacePersonUpdate_V4
     */
    public function setMyTransicsLink(\StructType\MyTransicsUpdateInfo $myTransicsLink = null)
    {
        $this->MyTransicsLink = $myTransicsLink;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\InterfacePersonUpdate_V4
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\InterfacePersonContactInfo_V3|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\InterfacePersonContactInfo_V3 $contactInfo
     * @return \StructType\InterfacePersonUpdate_V4
     */
    public function setContactInfo(\StructType\InterfacePersonContactInfo_V3 $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get SocialInfo value
     * @return \StructType\PersonSocialInfo_V2|null
     */
    public function getSocialInfo()
    {
        return $this->SocialInfo;
    }
    /**
     * Set SocialInfo value
     * @param \StructType\PersonSocialInfo_V2 $socialInfo
     * @return \StructType\InterfacePersonUpdate_V4
     */
    public function setSocialInfo(\StructType\PersonSocialInfo_V2 $socialInfo = null)
    {
        $this->SocialInfo = $socialInfo;
        return $this;
    }
}
