<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfacePersonResult_V10 StructType
 * @subpackage Structs
 */
class InterfacePersonResult_V10 extends Person_V6
{
    /**
     * The PersonTransicsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonTransicsId;
    /**
     * The Modification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modification;
    /**
     * The UpdateDatesList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUpdateDatesItem
     */
    public $UpdateDatesList;
    /**
     * The LastVehicleInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LastVehicleInfo_V4
     */
    public $LastVehicleInfo;
    /**
     * The TachoCardInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceTachoCardInfo_V3
     */
    public $TachoCardInfo;
    /**
     * The FormattedName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedName;
    /**
     * The Languages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonLanguages_V2
     */
    public $Languages;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfacePersonContactInfo_V4
     */
    public $ContactInfo;
    /**
     * The SocialInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonSocialInfo_V2
     */
    public $SocialInfo;
    /**
     * The GenericItemList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGenericItem_V1
     */
    public $GenericItemList;
    /**
     * The Groups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonGroups
     */
    public $Groups;
    /**
     * Constructor method for InterfacePersonResult_V10
     * @uses InterfacePersonResult_V10::setPersonTransicsId()
     * @uses InterfacePersonResult_V10::setModification()
     * @uses InterfacePersonResult_V10::setUpdateDatesList()
     * @uses InterfacePersonResult_V10::setLastVehicleInfo()
     * @uses InterfacePersonResult_V10::setTachoCardInfo()
     * @uses InterfacePersonResult_V10::setFormattedName()
     * @uses InterfacePersonResult_V10::setLanguages()
     * @uses InterfacePersonResult_V10::setContactInfo()
     * @uses InterfacePersonResult_V10::setSocialInfo()
     * @uses InterfacePersonResult_V10::setGenericItemList()
     * @uses InterfacePersonResult_V10::setGroups()
     * @param int $personTransicsId
     * @param string $modification
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     * @param \StructType\LastVehicleInfo_V4 $lastVehicleInfo
     * @param \StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo
     * @param string $formattedName
     * @param \StructType\PersonLanguages_V2 $languages
     * @param \StructType\InterfacePersonContactInfo_V4 $contactInfo
     * @param \StructType\PersonSocialInfo_V2 $socialInfo
     * @param \ArrayType\ArrayOfGenericItem_V1 $genericItemList
     * @param \StructType\PersonGroups $groups
     */
    public function __construct($personTransicsId = null, $modification = null, \ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null, \StructType\LastVehicleInfo_V4 $lastVehicleInfo = null, \StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo = null, $formattedName = null, \StructType\PersonLanguages_V2 $languages = null, \StructType\InterfacePersonContactInfo_V4 $contactInfo = null, \StructType\PersonSocialInfo_V2 $socialInfo = null, \ArrayType\ArrayOfGenericItem_V1 $genericItemList = null, \StructType\PersonGroups $groups = null)
    {
        $this
            ->setPersonTransicsId($personTransicsId)
            ->setModification($modification)
            ->setUpdateDatesList($updateDatesList)
            ->setLastVehicleInfo($lastVehicleInfo)
            ->setTachoCardInfo($tachoCardInfo)
            ->setFormattedName($formattedName)
            ->setLanguages($languages)
            ->setContactInfo($contactInfo)
            ->setSocialInfo($socialInfo)
            ->setGenericItemList($genericItemList)
            ->setGroups($groups);
    }
    /**
     * Get PersonTransicsId value
     * @return int
     */
    public function getPersonTransicsId()
    {
        return $this->PersonTransicsId;
    }
    /**
     * Set PersonTransicsId value
     * @param int $personTransicsId
     * @return \StructType\InterfacePersonResult_V10
     */
    public function setPersonTransicsId($personTransicsId = null)
    {
        // validation for constraint: int
        if (!is_null($personTransicsId) && !(is_int($personTransicsId) || ctype_digit($personTransicsId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personTransicsId, true), gettype($personTransicsId)), __LINE__);
        }
        $this->PersonTransicsId = $personTransicsId;
        return $this;
    }
    /**
     * Get Modification value
     * @return string
     */
    public function getModification()
    {
        return $this->Modification;
    }
    /**
     * Set Modification value
     * @param string $modification
     * @return \StructType\InterfacePersonResult_V10
     */
    public function setModification($modification = null)
    {
        // validation for constraint: string
        if (!is_null($modification) && !is_string($modification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modification, true), gettype($modification)), __LINE__);
        }
        $this->Modification = $modification;
        return $this;
    }
    /**
     * Get UpdateDatesList value
     * @return \ArrayType\ArrayOfUpdateDatesItem|null
     */
    public function getUpdateDatesList()
    {
        return $this->UpdateDatesList;
    }
    /**
     * Set UpdateDatesList value
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     * @return \StructType\InterfacePersonResult_V10
     */
    public function setUpdateDatesList(\ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null)
    {
        $this->UpdateDatesList = $updateDatesList;
        return $this;
    }
    /**
     * Get LastVehicleInfo value
     * @return \StructType\LastVehicleInfo_V4|null
     */
    public function getLastVehicleInfo()
    {
        return $this->LastVehicleInfo;
    }
    /**
     * Set LastVehicleInfo value
     * @param \StructType\LastVehicleInfo_V4 $lastVehicleInfo
     * @return \StructType\InterfacePersonResult_V10
     */
    public function setLastVehicleInfo(\StructType\LastVehicleInfo_V4 $lastVehicleInfo = null)
    {
        $this->LastVehicleInfo = $lastVehicleInfo;
        return $this;
    }
    /**
     * Get TachoCardInfo value
     * @return \StructType\InterfaceTachoCardInfo_V3|null
     */
    public function getTachoCardInfo()
    {
        return $this->TachoCardInfo;
    }
    /**
     * Set TachoCardInfo value
     * @param \StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo
     * @return \StructType\InterfacePersonResult_V10
     */
    public function setTachoCardInfo(\StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo = null)
    {
        $this->TachoCardInfo = $tachoCardInfo;
        return $this;
    }
    /**
     * Get FormattedName value
     * @return string|null
     */
    public function getFormattedName()
    {
        return $this->FormattedName;
    }
    /**
     * Set FormattedName value
     * @param string $formattedName
     * @return \StructType\InterfacePersonResult_V10
     */
    public function setFormattedName($formattedName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedName) && !is_string($formattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedName, true), gettype($formattedName)), __LINE__);
        }
        $this->FormattedName = $formattedName;
        return $this;
    }
    /**
     * Get Languages value
     * @return \StructType\PersonLanguages_V2|null
     */
    public function getLanguages()
    {
        return $this->Languages;
    }
    /**
     * Set Languages value
     * @param \StructType\PersonLanguages_V2 $languages
     * @return \StructType\InterfacePersonResult_V10
     */
    public function setLanguages(\StructType\PersonLanguages_V2 $languages = null)
    {
        $this->Languages = $languages;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\InterfacePersonContactInfo_V4|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\InterfacePersonContactInfo_V4 $contactInfo
     * @return \StructType\InterfacePersonResult_V10
     */
    public function setContactInfo(\StructType\InterfacePersonContactInfo_V4 $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get SocialInfo value
     * @return \StructType\PersonSocialInfo_V2|null
     */
    public function getSocialInfo()
    {
        return $this->SocialInfo;
    }
    /**
     * Set SocialInfo value
     * @param \StructType\PersonSocialInfo_V2 $socialInfo
     * @return \StructType\InterfacePersonResult_V10
     */
    public function setSocialInfo(\StructType\PersonSocialInfo_V2 $socialInfo = null)
    {
        $this->SocialInfo = $socialInfo;
        return $this;
    }
    /**
     * Get GenericItemList value
     * @return \ArrayType\ArrayOfGenericItem_V1|null
     */
    public function getGenericItemList()
    {
        return $this->GenericItemList;
    }
    /**
     * Set GenericItemList value
     * @param \ArrayType\ArrayOfGenericItem_V1 $genericItemList
     * @return \StructType\InterfacePersonResult_V10
     */
    public function setGenericItemList(\ArrayType\ArrayOfGenericItem_V1 $genericItemList = null)
    {
        $this->GenericItemList = $genericItemList;
        return $this;
    }
    /**
     * Get Groups value
     * @return \StructType\PersonGroups|null
     */
    public function getGroups()
    {
        return $this->Groups;
    }
    /**
     * Set Groups value
     * @param \StructType\PersonGroups $groups
     * @return \StructType\InterfacePersonResult_V10
     */
    public function setGroups(\StructType\PersonGroups $groups = null)
    {
        $this->Groups = $groups;
        return $this;
    }
}
