<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfacePersonInsert_V4 StructType
 * @subpackage Structs
 */
class InterfacePersonInsert_V4 extends Person_V6
{
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Title;
    /**
     * The TachoCardInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceTachoCard_V2
     */
    public $TachoCardInfo;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfacePersonContactInfo_V3
     */
    public $ContactInfo;
    /**
     * The MyTransicsLink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MyTransicsInfo
     */
    public $MyTransicsLink;
    /**
     * The SocialInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonSocialInfo
     */
    public $SocialInfo;
    /**
     * Constructor method for InterfacePersonInsert_V4
     * @uses InterfacePersonInsert_V4::setTitle()
     * @uses InterfacePersonInsert_V4::setTachoCardInfo()
     * @uses InterfacePersonInsert_V4::setLanguage()
     * @uses InterfacePersonInsert_V4::setContactInfo()
     * @uses InterfacePersonInsert_V4::setMyTransicsLink()
     * @uses InterfacePersonInsert_V4::setSocialInfo()
     * @param string $title
     * @param \StructType\InterfaceTachoCard_V2 $tachoCardInfo
     * @param string $language
     * @param \StructType\InterfacePersonContactInfo_V3 $contactInfo
     * @param \StructType\MyTransicsInfo $myTransicsLink
     * @param \StructType\PersonSocialInfo $socialInfo
     */
    public function __construct($title = null, \StructType\InterfaceTachoCard_V2 $tachoCardInfo = null, $language = null, \StructType\InterfacePersonContactInfo_V3 $contactInfo = null, \StructType\MyTransicsInfo $myTransicsLink = null, \StructType\PersonSocialInfo $socialInfo = null)
    {
        $this
            ->setTitle($title)
            ->setTachoCardInfo($tachoCardInfo)
            ->setLanguage($language)
            ->setContactInfo($contactInfo)
            ->setMyTransicsLink($myTransicsLink)
            ->setSocialInfo($socialInfo);
    }
    /**
     * Get Title value
     * @return string
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @uses \EnumType\EnumTitle::valueIsValid()
     * @uses \EnumType\EnumTitle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $title
     * @return \StructType\InterfacePersonInsert_V4
     */
    public function setTitle($title = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTitle::valueIsValid($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTitle', is_array($title) ? implode(', ', $title) : var_export($title, true), implode(', ', \EnumType\EnumTitle::getValidValues())), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get TachoCardInfo value
     * @return \StructType\InterfaceTachoCard_V2|null
     */
    public function getTachoCardInfo()
    {
        return $this->TachoCardInfo;
    }
    /**
     * Set TachoCardInfo value
     * @param \StructType\InterfaceTachoCard_V2 $tachoCardInfo
     * @return \StructType\InterfacePersonInsert_V4
     */
    public function setTachoCardInfo(\StructType\InterfaceTachoCard_V2 $tachoCardInfo = null)
    {
        $this->TachoCardInfo = $tachoCardInfo;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\InterfacePersonInsert_V4
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\InterfacePersonContactInfo_V3|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\InterfacePersonContactInfo_V3 $contactInfo
     * @return \StructType\InterfacePersonInsert_V4
     */
    public function setContactInfo(\StructType\InterfacePersonContactInfo_V3 $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get MyTransicsLink value
     * @return \StructType\MyTransicsInfo|null
     */
    public function getMyTransicsLink()
    {
        return $this->MyTransicsLink;
    }
    /**
     * Set MyTransicsLink value
     * @param \StructType\MyTransicsInfo $myTransicsLink
     * @return \StructType\InterfacePersonInsert_V4
     */
    public function setMyTransicsLink(\StructType\MyTransicsInfo $myTransicsLink = null)
    {
        $this->MyTransicsLink = $myTransicsLink;
        return $this;
    }
    /**
     * Get SocialInfo value
     * @return \StructType\PersonSocialInfo|null
     */
    public function getSocialInfo()
    {
        return $this->SocialInfo;
    }
    /**
     * Set SocialInfo value
     * @param \StructType\PersonSocialInfo $socialInfo
     * @return \StructType\InterfacePersonInsert_V4
     */
    public function setSocialInfo(\StructType\PersonSocialInfo $socialInfo = null)
    {
        $this->SocialInfo = $socialInfo;
        return $this;
    }
}
